/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.contentcontainer.content;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentInterface;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.contribution.contentcontainer.content.SilverpeasContentManager;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;

public abstract class AbstractSilverpeasContentManager
implements SilverpeasContentManager {
    protected ContentManagementEngine getContentManager() {
        return ContentManagementEngineProvider.getContentManagementEngine();
    }

    @Override
    public List<SilverContentInterface> getSilverContentByReference(List<ResourceReference> resourceReferences, String currentUserId) {
        List<Contribution> contributions = this.getAccessibleContributions(resourceReferences, currentUserId);
        return contributions.stream().map(this::convert).collect(Collectors.toList());
    }

    @Override
    public <T extends Contribution> int getSilverContentId(T contribution) {
        ContributionIdentifier contributionId = contribution.getIdentifier();
        return this.getSilverContentId(contributionId.getLocalId(), contributionId.getComponentInstanceId());
    }

    @Override
    public <T extends Contribution> int getOrCreateSilverContentId(T contribution) {
        int contentId = this.getSilverContentId(contribution);
        if (contentId == -1) {
            contentId = this.createSilverContent(contribution, contribution.getLastUpdater().getId());
        }
        return contentId;
    }

    @Override
    public int getOrCreateSilverContentId(String resourceId, String componentInstanceId) {
        Contribution contribution = this.getContribution(resourceId, componentInstanceId).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("impossible to get contribution from id {0} into component instance {1}", resourceId, componentInstanceId)));
        return this.getOrCreateSilverContentId(contribution);
    }

    protected abstract Optional<Contribution> getContribution(String var1, String var2);

    protected abstract List<Contribution> getAccessibleContributions(List<ResourceReference> var1, String var2);

    public int getSilverContentId(String resourceId, String componentInstanceId) {
        try {
            return this.getContentManager().getSilverContentId(resourceId, componentInstanceId);
        }
        catch (ContentManagerException e) {
            throw new SilverpeasRuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public <T extends Contribution> int createSilverContent(T contribution, String userId) {
        return (Integer)Transaction.performInOne(() -> {
            try (Connection connection = DBUtil.openConnection();){
                Integer n = this.createSilverContent(connection, contribution, userId);
                return n;
            }
        });
    }

    public int createSilverContent(Connection connection, Contribution contribution, String userId) throws ContentManagerException {
        ContributionIdentifier contributionId = contribution.getIdentifier();
        SilverContentVisibility scv = this.computeSilverContentVisibility(contribution);
        return this.getContentManager().addSilverContent(connection, contributionId.getLocalId(), contributionId.getComponentInstanceId(), userId, scv);
    }

    public int createSilverContent(Connection connection, Contribution contribution, String userId, boolean visible) throws ContentManagerException {
        ContributionIdentifier contributionId = contribution.getIdentifier();
        SilverContentVisibility scv = this.computeSilverContentVisibility(contribution);
        scv.setVisibilityAttributes(visible);
        return this.getContentManager().addSilverContent(connection, contributionId.getLocalId(), contributionId.getComponentInstanceId(), userId, scv);
    }

    public int createSilverContent(Connection connection, String resourceId, String componentInstanceId, String userId) throws ContentManagerException {
        SilverContentVisibility scv = this.computeSilverContentVisibility(null);
        return this.getContentManager().addSilverContent(connection, resourceId, componentInstanceId, userId, scv);
    }

    public <T extends Contribution> void updateSilverContentVisibility(T contribution) throws ContentManagerException {
        int silverContentId = this.getSilverContentId(contribution);
        if (silverContentId == -1) {
            this.createSilverContent(null, contribution, contribution.getLastUpdater().getId());
        } else {
            SilverContentVisibility scv = this.computeSilverContentVisibility(contribution);
            this.getContentManager().updateSilverContentVisibilityAttributes(scv, silverContentId);
        }
    }

    public <T extends Contribution> void updateSilverContentVisibility(T contribution, boolean visibility) throws ContentManagerException {
        int silverContentId = this.getSilverContentId(contribution);
        if (silverContentId == -1) {
            this.createSilverContent(null, contribution, contribution.getLastUpdater().getId(), visibility);
        } else {
            SilverContentVisibility scv = this.computeSilverContentVisibility(contribution);
            scv.setVisibilityAttributes(visibility);
            this.getContentManager().updateSilverContentVisibilityAttributes(scv, silverContentId);
        }
    }

    protected <T extends Contribution> SilverContentVisibility computeSilverContentVisibility(T contribution) {
        if (contribution == null) {
            throw new IllegalArgumentException("contribution parameter must not be null");
        }
        return new SilverContentVisibility();
    }

    @Override
    public void deleteSilverContent(String resourceId, String componentInstanceId) {
        Transaction.performInOne(() -> {
            try (Connection connection = DBUtil.openConnection();){
                this.deleteSilverContent(connection, resourceId, componentInstanceId);
            }
            return null;
        });
    }

    public void deleteSilverContent(Contribution contribution) {
        ContributionIdentifier contributionId = contribution.getIdentifier();
        this.deleteSilverContent(contributionId.getLocalId(), contributionId.getComponentInstanceId());
    }

    public void deleteSilverContent(Connection connection, String resourceId, String componentInstanceId) throws ContentManagerException {
        int contentId = this.getSilverContentId(resourceId, componentInstanceId);
        if (contentId != -1) {
            this.getContentManager().removeSilverContent(connection, contentId);
        }
    }

    private <T extends Contribution> SilverContentInterface convert(T instance) {
        String componentInstanceId = instance.getIdentifier().getComponentInstanceId();
        return new ContributionWrapper(instance, this.getContentIconFileName(componentInstanceId));
    }

    protected abstract String getContentIconFileName(String var1);

    public static class ContributionWrapper
    implements SilverContentInterface {
        private final Contribution wrappedInstance;
        private final ContributionIdentifier contributionId;
        private final String contentIconFileName;
        private final SilverContentInterface silverContentInterface;
        private LocalizedContribution contribution;

        private ContributionWrapper(Contribution contribution, String contentIconFileName) {
            this.contributionId = contribution.getIdentifier();
            this.wrappedInstance = contribution;
            this.contribution = LocalizedContribution.from((Contribution)contribution);
            this.contentIconFileName = contentIconFileName;
            this.silverContentInterface = contribution instanceof SilverContentInterface ? (SilverContentInterface)contribution : null;
        }

        private void setRightLocalizedContribution(String language) {
            if (!language.equals(this.contribution.getLanguage())) {
                this.contribution = LocalizedContribution.from((Contribution)this.contribution, (String)language);
            }
        }

        public Contribution getWrappedInstance() {
            return this.wrappedInstance;
        }

        @Override
        public String getId() {
            return this.contributionId.getLocalId();
        }

        @Override
        public String getName() {
            return this.contribution.getTitle();
        }

        @Override
        public String getName(String language) {
            if (this.silverContentInterface != null) {
                return this.silverContentInterface.getName(language);
            }
            this.setRightLocalizedContribution(language);
            return this.contribution.getTitle();
        }

        @Override
        public String getDescription(String language) {
            if (this.silverContentInterface != null) {
                return this.silverContentInterface.getDescription(language);
            }
            this.setRightLocalizedContribution(language);
            return this.contribution.getDescription();
        }

        @Override
        public String getURL() {
            if (this.silverContentInterface != null) {
                return this.silverContentInterface.getURL();
            }
            return null;
        }

        @Override
        public String getInstanceId() {
            return this.contributionId.getComponentInstanceId();
        }

        @Override
        public String getComponentInstanceId() {
            return this.contributionId.getComponentInstanceId();
        }

        @Override
        public String getDate() {
            if (this.silverContentInterface != null) {
                return this.silverContentInterface.getDate();
            }
            return DateUtil.date2SQLDate((Date)this.contribution.getLastUpdateDate());
        }

        @Override
        public String getSilverCreationDate() {
            if (this.silverContentInterface != null) {
                return this.silverContentInterface.getSilverCreationDate();
            }
            return DateUtil.date2SQLDate((Date)this.contribution.getCreationDate());
        }

        @Override
        public String getIconUrl() {
            return this.contentIconFileName;
        }

        @Override
        public String getCreatorId() {
            if (this.silverContentInterface != null) {
                return this.silverContentInterface.getCreatorId();
            }
            return this.contribution.getCreator().getId();
        }

        @Override
        public User getCreator() {
            return this.contribution.getCreator();
        }

        @Override
        public User getLastUpdater() {
            return this.contribution.getLastUpdater();
        }

        @Override
        public Date getCreationDate() {
            return this.contribution.getCreationDate();
        }

        @Override
        public Date getLastUpdateDate() {
            return this.contribution.getLastUpdateDate();
        }

        @Override
        public String getSilverpeasContentId() {
            if (this.contribution instanceof SilverpeasContent) {
                return ((SilverpeasContent)this.contribution).getSilverpeasContentId();
            }
            return SilverContentInterface.super.getSilverpeasContentId();
        }

        @Override
        public ContributionIdentifier getIdentifier() {
            return this.contributionId;
        }

        public String getTitle() {
            return this.contribution.getTitle();
        }

        public String getDescription() {
            return this.contribution.getDescription();
        }

        public String getContributionType() {
            return this.contributionId.getType();
        }

        public boolean isIndexable() {
            return this.contribution.isIndexable();
        }

        public boolean canBeAccessedBy(User user) {
            return this.contribution.canBeAccessedBy(user);
        }

        public boolean canBeModifiedBy(User user) {
            return this.contribution.canBeModifiedBy(user);
        }

        public boolean canBeDeletedBy(User user) {
            return this.contribution.canBeDeletedBy(user);
        }

        @Override
        public Collection<String> getLanguages() {
            if (this.silverContentInterface != null) {
                return this.silverContentInterface.getLanguages();
            }
            return Collections.emptyList();
        }
    }
}

