/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.wysiwyg.service.directive;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.silverpeas.core.contribution.content.wysiwyg.service.directive.AbstractDirective;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.StringDataExtractor;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

public class ImageUrlAccordingToHtmlSizeDirective
extends AbstractDirective {
    private static final String WIDTH_ATTR = "width";
    private static final String HEIGHT_ATTR = "height";
    private static final String STYLE_ATTR = "style";
    private static final List<StringDataExtractor.RegexpPatternDirective> WIDTH_NUMERIC_VALUE = Arrays.asList(StringDataExtractor.RegexpPatternDirective.regexp(Pattern.compile("(?i)widthAttr[ ]*([0-9]+.?)"), 1), StringDataExtractor.RegexpPatternDirective.regexp(Pattern.compile("(?i)[ ;]width[ ]*:[ ]*([0-9]+.?)"), 1));
    private static final List<StringDataExtractor.RegexpPatternDirective> HEIGHT_NUMERIC_VALUE = Arrays.asList(StringDataExtractor.RegexpPatternDirective.regexp(Pattern.compile("(?i)heightAttr[ ]*([0-9]+.?)"), 1), StringDataExtractor.RegexpPatternDirective.regexp(Pattern.compile("(?i)[ ;]height[ ]*:[ ]*([0-9]+.?)"), 1));
    private final int minWidth;

    public ImageUrlAccordingToHtmlSizeDirective() {
        this(null);
    }

    public ImageUrlAccordingToHtmlSizeDirective(Integer minWidth) {
        this.minWidth = minWidth != null ? minWidth : 0;
    }

    @Override
    public void prepareReplacements(Source source, Map<String, String> replacements) {
        List imgElements = source.getAllElements("img");
        if (!imgElements.isEmpty()) {
            List<SrcTranslator> translators = SrcTranslator.getAll();
            for (Element currentImg : imgElements) {
                String imgTagContent = currentImg.toString();
                Attribute srcAtt = currentImg.getAttributes().get("src");
                if (srcAtt == null || srcAtt.getValueSegment() == null) continue;
                String src = srcAtt.getValueSegment().toString();
                if (replacements.containsKey(imgTagContent)) continue;
                Mutable width = Mutable.of((Object)this.getWidth(currentImg));
                Mutable height = Mutable.of((Object)this.getHeight(currentImg));
                this.applyMinWidthIfNecessary((Mutable<String>)width, (Mutable<String>)height);
                translators.stream().filter(s -> s.isCompliantUrl(src)).findFirst().map(s -> s.translateUrl(src, (String)width.get(), (String)height.get())).filter(t -> !src.equals(t)).ifPresent(t -> replacements.put(imgTagContent, imgTagContent.replace(src, (CharSequence)t)));
            }
        }
    }

    private void applyMinWidthIfNecessary(Mutable<String> width, Mutable<String> height) {
        Optional.of(this.minWidth).filter(w -> w > 0).map(o -> (String)width.get()).filter(StringUtil::isDefined).map(Integer::parseInt).ifPresent(w -> {
            BigDecimal ratio = new BigDecimal((int)w).divide(new BigDecimal(this.minWidth), 10, RoundingMode.HALF_UP);
            if (ratio.floatValue() < 1.0f) {
                width.set((Object)String.valueOf(this.minWidth));
                height.set((Object)((String)height.filter(StringUtil::isDefined).map(BigDecimal::new).map(h -> h.divide(ratio, 0, RoundingMode.HALF_UP)).map(BigDecimal::toString).orElse((Object)"")));
            }
        });
    }

    private String getWidth(Element imgElement) {
        return this.getSizeOf(WIDTH_NUMERIC_VALUE, imgElement, WIDTH_ATTR);
    }

    private String getHeight(Element imgElement) {
        return this.getSizeOf(HEIGHT_NUMERIC_VALUE, imgElement, HEIGHT_ATTR);
    }

    private String getSizeOf(List<StringDataExtractor.RegexpPatternDirective> directives, Element imgElement, String attrName) {
        String stringToParse = ";" + imgElement.getAttributeValue(STYLE_ATTR) + "@" + attrName + "Attr" + imgElement.getAttributeValue(attrName);
        List<String> sizeData = StringDataExtractor.from(stringToParse.replaceAll("[\n\r]*", "")).withDirectives(directives).extract();
        return sizeData.stream().filter(s -> s.charAt(s.length() - 1) != '%').map(s -> Character.isDigit(s.charAt(s.length() - 1)) ? s : s.substring(0, s.length() - 1)).findFirst().orElse("");
    }

    public static abstract class SrcWithSizeParametersTranslator
    implements SrcTranslator {
        private static final Pattern PATTERN = Pattern.compile("(?i)(&|&amp;)size[ ]*=[ ]*[0-9 x]+");
        private static final String AMP = "&amp;";

        @Override
        public String translateUrl(String url, String width, String height) {
            Matcher matcher = PATTERN.matcher(url);
            String existingPart = matcher.find() ? matcher.group() : "";
            Object newUrl = url.replace(existingPart, "");
            StringBuilder sizeUrlPart = new StringBuilder().append(width).append("x").append(height);
            if (sizeUrlPart.length() > 1) {
                String separator = url.indexOf(63) < 0 ? "?" : (url.contains(AMP) ? AMP : "&");
                sizeUrlPart.insert(0, separator + "Size=");
                newUrl = (String)newUrl + sizeUrlPart;
            }
            return newUrl;
        }
    }

    public static interface SrcTranslator {
        public static List<SrcTranslator> getAll() {
            List asList = ServiceProvider.getAllServices(SrcTranslator.class, (Annotation[])new Annotation[0]).stream().sorted(Comparator.comparing(o -> o.getClass().getSimpleName())).collect(Collectors.toList());
            return Collections.unmodifiableList(asList);
        }

        public boolean isCompliantUrl(String var1);

        public String translateUrl(String var1, String var2, String var3);
    }
}

