/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.form;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.contribution.content.form.AbstractForm;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.content.form.record.Parameter;
import org.silverpeas.core.contribution.content.form.record.ParameterValue;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class XmlSearchForm
extends AbstractForm {
    private static final String DIV_TAG_END = "</div>";
    public static final String EXTRA_FIELD_PERIOD = "extraSearchFieldUpdatedFor";
    public static final String EXTRA_FIELD_SPACE = "extraSearchFieldSpace";

    public XmlSearchForm(RecordTemplate template) throws FormException {
        super(template);
    }

    @Override
    public void displayScripts(JspWriter jw, PagesContext pagesContext) {
        PrintWriter out = new PrintWriter((Writer)jw, true);
        out.append(this.getJavascriptSnippet());
        out.flush();
    }

    @Override
    public String toString(PagesContext pagesContext, DataRecord record) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        this.display(pw, pagesContext, record);
        return sw.toString();
    }

    @Override
    public void display(JspWriter jw, PagesContext pageContext, DataRecord record) {
        PrintWriter out = new PrintWriter((Writer)jw, true);
        this.display(out, pageContext, record);
    }

    private void display(PrintWriter jw, PagesContext pagesContext, DataRecord record) {
        ArrayList<FieldTemplate> listFields;
        String language = pagesContext.getLanguage();
        PrintWriter out = new PrintWriter((Writer)jw, true);
        out.println("<div class=\"forms " + this.getFormName() + " mode-search\">");
        if (pagesContext.getPrintTitle() && StringUtil.isDefined((String)this.getTitle())) {
            out.println("<h2 class=\"form-title\">");
            out.println(this.getTitle());
            out.println("</h2>");
        }
        if (CollectionUtil.isNotEmpty(listFields = new ArrayList<FieldTemplate>(this.getFieldTemplates()))) {
            if (pagesContext.isBorderPrinted()) {
                out.println("<ul class=\"fields form-border\">");
            } else {
                out.println("<ul class=\"fields\">");
            }
            out.flush();
            PagesContext pc = new PagesContext(pagesContext);
            pc.setUseMandatory(false);
            pc.setIgnoreDefaultValues(true);
            if (pagesContext.isExtraSearchFieldPeriod()) {
                GenericFieldTemplate fieldDate = this.generateListboxFieldFromProperties(EXTRA_FIELD_PERIOD, "form.search.field.period", pagesContext);
                listFields.add(fieldDate);
            }
            if (pagesContext.isExtraSearchFieldSpace()) {
                GenericFieldTemplate fieldSpace = this.generateListboxFieldFromMainSpaces(EXTRA_FIELD_SPACE, "form.search.field.space", pagesContext);
                listFields.add(fieldSpace);
            }
            this.displayFields(out, record, listFields, language, pc);
            out.println("</ul>");
            out.println(DIV_TAG_END);
            out.flush();
        }
    }

    private void displayFields(PrintWriter out, DataRecord record, List<FieldTemplate> listFields, String language, PagesContext pc) {
        for (FieldTemplate fieldTemplate : listFields) {
            String fieldName = fieldTemplate.getFieldName();
            String fieldLabel = fieldTemplate.getLabel(language);
            FieldDisplayer<Field> fieldDisplayer = this.getFieldDisplayer(fieldTemplate);
            if (fieldDisplayer == null) continue;
            boolean checkbox = "checkbox".equalsIgnoreCase(fieldTemplate.getDisplayerName());
            out.println("<li class=\"field field_" + fieldName + "\" id=\"form-row-" + fieldName + "\">");
            out.println("<div>");
            out.println("<label for=\"" + fieldName + "\">" + fieldLabel + "</label>");
            if (checkbox) {
                out.println(this.getOperatorsSnippet(fieldName, pc));
            }
            out.println(DIV_TAG_END);
            out.println("<div class=\"fieldInput\">");
            try {
                fieldDisplayer.display(out, record.getField(fieldName), fieldTemplate, pc);
            }
            catch (FormException fe) {
                SilverLogger.getLogger((Object)this).error(fe.getMessage(), (Throwable)((Object)fe));
            }
            out.println(DIV_TAG_END);
            out.println("</li>");
            out.flush();
        }
    }

    private String getOperatorsSnippet(String fieldName, PagesContext pc) {
        StringBuilder sb = new StringBuilder();
        String classAND = "";
        String classOR = "";
        String currentOperator = "";
        String searchOperator = pc.getSearchOperator(fieldName, Util.getDefaultOperator());
        if (searchOperator.equals("AND")) {
            classAND = "active";
            currentOperator = "AND";
        } else if (searchOperator.equals("OR")) {
            classOR = "active";
            currentOperator = "OR";
        }
        sb.append("<div class=\"operators\">");
        if (Util.isOperatorsChoiceEnabled()) {
            sb.append("<a href=\"#\" id=\"").append(fieldName).append("OperatorAND\" onclick=\"javascript:$('#").append(fieldName).append("Operator').val('").append("AND").append("');$(this).attr('class','active');$('#").append(fieldName).append("OperatorOR').attr('class','');return false;\" class=\"").append(classAND).append("\"/>").append(Util.getString("Operator.AND", pc.getLanguage())).append("</a>");
            sb.append(" / ");
            sb.append("<a href=\"#\" id=\"").append(fieldName).append("OperatorOR\" onclick=\"javascript:$('#").append(fieldName).append("Operator').val('").append("OR").append("');$(this).attr('class','active');$('#").append(fieldName).append("OperatorAND').attr('class','');return false;\" class=\"").append(classOR).append("\"/>").append(Util.getString("Operator.OR", pc.getLanguage())).append("</a>");
        }
        sb.append("<input type=\"hidden\" name=\"").append(fieldName).append("Operator\" id=\"").append(fieldName).append("Operator\" value=\"").append(currentOperator).append("\"/>");
        sb.append(DIV_TAG_END);
        return sb.toString();
    }

    private GenericFieldTemplate generateListboxFieldFromMainSpaces(String fieldName, String prefix, PagesContext pc) {
        String label = Util.getString(prefix + ".label", pc.getLanguage());
        String[] mainSpaceIds = OrganizationController.get().getAllRootSpaceIds(pc.getUserId());
        StringBuilder keys = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (String spaceId : mainSpaceIds) {
            SpaceInstLight space = OrganizationController.get().getSpaceInstLightById(spaceId);
            if (keys.length() > 0) {
                keys.append("##");
                values.append("##");
            }
            keys.append(space.getId());
            values.append(space.getName(pc.getLanguage()));
        }
        return this.generateListboxField(fieldName, label, keys.toString(), values.toString());
    }

    private GenericFieldTemplate generateListboxFieldFromProperties(String fieldName, String prefix, PagesContext pc) {
        String label = Util.getString(prefix + ".label", pc.getLanguage());
        String keys = Util.getSetting(prefix + ".keys");
        String values = Util.getString(prefix + ".values", pc.getLanguage());
        return this.generateListboxField(fieldName, label, keys, values);
    }

    private GenericFieldTemplate generateListboxField(String fieldName, String label, String keys, String values) {
        GenericFieldTemplate fieldDate = new GenericFieldTemplate();
        fieldDate.setFieldName(fieldName);
        try {
            fieldDate.setTypeName("text");
        }
        catch (FormException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
        }
        fieldDate.setDisplayerName("listbox");
        fieldDate.setSearchable(true);
        fieldDate.setLabel(label);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter paramKeys = new Parameter();
        paramKeys.setName("keys");
        ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
        ParameterValue paramValue = new ParameterValue();
        paramValue.setLang("fr");
        paramValue.setValue(keys);
        parameterValues.add(paramValue);
        paramKeys.setParameterValues(parameterValues);
        Parameter paramValues = new Parameter();
        paramValues.setName("values");
        parameterValues = new ArrayList();
        paramValue = new ParameterValue();
        paramValue.setLang("fr");
        paramValue.setValue(values);
        parameterValues.add(paramValue);
        paramValues.setParameterValues(parameterValues);
        parameters.add(paramKeys);
        parameters.add(paramValues);
        fieldDate.setParametersObj(parameters);
        return fieldDate;
    }
}

