/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.Printable;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.iframe;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.displayers.AbstractTextFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.kernel.util.StringUtil;

public class MapFieldDisplayer
extends AbstractTextFieldDisplayer {
    public static final String PARAM_MAP = "map";
    public static final String PARAM_HEIGHT = "height";
    public static final String PARAM_WIDTH = "width";
    public static final String PARAM_KIND = "kind";
    public static final String PARAM_ZOOM = "zoom";
    public static final String PARAM_ENLARGE = "enlarge";
    public static final String KIND_NORMAL = "m";
    public static final String KIND_SATELLITE = "k";
    public static final String KIND_HYBRID = "h";
    public static final String KIND_RELIEF = "t";
    private static final String AMP = "&amp;";

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        if (field == null) {
            return;
        }
        AbstractTextFieldDisplayer.FieldProperties fieldProps = this.getFieldProperties(template, field, pageContext);
        if (!template.isHidden()) {
            if (template.isReadOnly()) {
                this.printOutReadOnlyField(fieldProps, out, pageContext);
            } else if (!template.isDisabled()) {
                this.printOutEditableField(fieldProps, out, pageContext);
            }
        }
    }

    private void printOutEditableField(AbstractTextFieldDisplayer.FieldProperties fieldProps, PrintWriter out, PagesContext pageContext) {
        FieldTemplate template = fieldProps.getTemplate();
        input textInput = new input();
        textInput.setName(fieldProps.getFieldName());
        textInput.setID(fieldProps.getFieldName());
        textInput.setValue(fieldProps.getValue());
        textInput.setSize("50");
        textInput.setType(template.isHidden() ? "hidden" : "text");
        if (template.isDisabled()) {
            textInput.setDisabled(true);
        } else if (template.isReadOnly()) {
            textInput.setReadOnly(true);
        }
        img image = MapFieldDisplayer.getMandatoryIcon(template, pageContext);
        Printable elt = this.setImage(textInput, image);
        out.println(elt);
    }

    private void printOutReadOnlyField(AbstractTextFieldDisplayer.FieldProperties fieldProps, PrintWriter out, PagesContext pageContext) {
        Map<String, String> parameters = fieldProps.getParameters();
        String value = fieldProps.getValue();
        StringBuilder src = new StringBuilder(50);
        src.append("https://maps.google.fr/maps?");
        src.append("hl=").append(pageContext.getLanguage()).append(AMP);
        src.append("source=embed&amp;");
        src.append("layer=c&amp;");
        src.append("t=").append(this.getParameterValue(parameters, PARAM_KIND, KIND_NORMAL)).append(AMP);
        src.append("q=").append(value).append(AMP);
        String zoom = this.getParameterValue(parameters, PARAM_ZOOM, null);
        if (StringUtil.isDefined((String)zoom)) {
            src.append("z=").append(zoom).append(AMP);
        }
        src.append("iwloc=dummy");
        String link = src.toString();
        a href = new a();
        href.setHref(link);
        href.setTarget("_blank");
        href.addElement(value);
        boolean map = StringUtil.getBooleanValue((String)this.getParameterValue(parameters, PARAM_MAP, "false"));
        boolean enlarge = StringUtil.getBooleanValue((String)this.getParameterValue(parameters, PARAM_ENLARGE, "false"));
        ElementContainer container = new ElementContainer();
        if (map) {
            iframe anIFrame = new iframe();
            anIFrame.addAttribute(PARAM_WIDTH, this.getParameterValue(parameters, PARAM_WIDTH, "425"));
            anIFrame.addAttribute(PARAM_HEIGHT, this.getParameterValue(parameters, PARAM_HEIGHT, "350"));
            anIFrame.setFrameBorder(false);
            anIFrame.setScrolling("no");
            anIFrame.setMarginHeight(0);
            anIFrame.setMarginWidth(0);
            anIFrame.setSrc(link.replace("source", "output"));
            container.addElement((Element)anIFrame);
            if (enlarge) {
                container.addElement("<br>");
                container.addElement("<small class=\"map-enlarge\">");
                container.addElement((Element)href);
                container.addElement("</small>");
            }
        } else {
            container.addElement((Element)href);
        }
        out.print(container);
    }

    private String getParameterValue(Map<String, String> parameters, String name, String defaultValue) {
        return parameters.getOrDefault(name, defaultValue);
    }
}

