/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.displayers.CheckBoxDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class ListBoxFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        return new String[]{"text"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        ListBoxFieldDisplayer.produceMandatoryCheck(out, template, pagesContext);
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String keys = "";
        StringBuilder html2 = new StringBuilder();
        String language = pageContext.getLanguage();
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(language);
        String value = this.getDefaultValue(template, pageContext);
        if (field != null && !field.isNull()) {
            value = field.getValue(language);
        }
        ListBoxFieldDisplayer.generateCssClass(html2, fieldName, parameters);
        if (template.isDisabled() || template.isReadOnly()) {
            html2.append(" disabled");
        }
        html2.append(" >\n").append("<option value=\"\"></option>\n");
        if (parameters.containsKey("keys")) {
            keys = parameters.get("keys");
        }
        String values = parameters.getOrDefault("values", keys);
        StringTokenizer stKeys = new StringTokenizer(keys, "##");
        StringTokenizer stValues = new StringTokenizer(values, "##");
        int nbTokens = stKeys.countTokens();
        if (stKeys.countTokens() != stValues.countTokens()) {
            SilverLogger.getLogger((Object)this).error("Illegal Parameters. Key count = {0}, values count = {1}", new Object[]{stKeys.countTokens(), stValues.countTokens()});
        } else {
            for (int i = 0; i < nbTokens; ++i) {
                String optKey = stKeys.nextToken();
                String optValue = stValues.nextToken();
                html2.append("<option ");
                if (optKey.equals(value) || optValue.equals(value)) {
                    html2.append(" selected ");
                }
                html2.append("value=\"").append(optKey).append("\">").append(optValue).append("</option>\n");
            }
        }
        html2.append("</select>\n");
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
            html2.append(Util.getMandatorySnippet());
        }
        out.println(html2);
    }

    private static void generateCssClass(StringBuilder html2, String fieldName, Map<String, String> parameters) {
        Object cssClass = null;
        if (parameters.containsKey("class") && StringUtil.isDefined((String)(cssClass = parameters.get("class")))) {
            cssClass = "class=\"" + (String)cssClass + "\"";
        }
        if (StringUtil.isDefined(cssClass)) {
            html2.append("<select ").append((String)cssClass).append(" id=\"").append(fieldName).append("\" name=\"").append(fieldName).append("\"");
        } else {
            html2.append("<select id=\"").append(fieldName).append("\" name=\"").append(fieldName).append("\"");
        }
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        CheckBoxDisplayer.setFieldValue(newValue, field, pagesContext);
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

