/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.Optional;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;

public interface ContributionVisibility
extends Serializable {
    public Optional<Period> getSpecificPeriod();

    public Period getPeriod();

    default public boolean isActive() {
        return this.getPeriod().includes((Temporal)OffsetDateTime.now());
    }

    default public boolean willBeActive() {
        return OffsetDateTime.now().isBefore(TemporalConverter.asOffsetDateTime((Temporal)this.getPeriod().getStartDate()));
    }

    default public boolean hasBeenActive() {
        return OffsetDateTime.now().isAfter(TemporalConverter.asOffsetDateTime((Temporal)this.getPeriod().getEndDate()));
    }
}

