/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.silverpeas.core.chart.ChartItem;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractChartItem<D>
implements ChartItem {
    private String title = "";
    private Map<String, String> extra = null;

    @Override
    public String getTitle() {
        return this.title;
    }

    public <T extends AbstractChartItem<D>> T addExtra(String key, String value) {
        if (this.extra == null) {
            this.extra = new LinkedHashMap<String, String>();
        }
        this.extra.put(key, value);
        return (T)this;
    }

    public Object getExtra(String key) {
        return this.extra == null ? null : this.extra.get(key);
    }

    public <T extends AbstractChartItem<D>> T withTitle(String title) {
        this.title = StringUtil.defaultStringIfNotDefined((String)title);
        return (T)this;
    }

    @Override
    public final String asJson() {
        return JSONCodec.encodeObject(this.getJsonProducer());
    }

    protected final UnaryOperator<JSONCodec.JSONObject> getJsonProducer() {
        return itemAsJson -> {
            itemAsJson.put("title", this.getTitle());
            this.completeJsonData((JSONCodec.JSONObject)itemAsJson);
            if (this.extra != null) {
                itemAsJson.putJSONObject("extra", jsonExtra -> {
                    for (Map.Entry<String, String> entry : this.extra.entrySet()) {
                        jsonExtra.put(entry.getKey(), entry.getValue());
                    }
                    return jsonExtra;
                });
            }
            return itemAsJson;
        };
    }

    protected abstract void completeJsonData(JSONCodec.JSONObject var1);
}

