/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification;

import java.util.Collection;
import java.util.Collections;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.PlannedOnCalendar;
import org.silverpeas.core.calendar.notification.AbstractCalendarEventUserNotificationBuilder;
import org.silverpeas.core.calendar.notification.CalendarOperation;
import org.silverpeas.core.calendar.subscription.CalendarSubscriptionConstants;
import org.silverpeas.core.notification.user.UserSubscriptionNotificationBehavior;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.subscription.SubscriberDirective;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberMapBySubscriberType;

class SubscriberNotificationBuilder
extends AbstractCalendarEventUserNotificationBuilder
implements UserSubscriptionNotificationBehavior {
    private final SubscriptionSubscriberMapBySubscriberType subscriberIdsByTypes;
    private Collection<String> userIdsToExclude = Collections.emptyList();

    SubscriberNotificationBuilder(CalendarEvent calendarEvent, NotifAction action) {
        super((PlannedOnCalendar)calendarEvent, action);
        this.subscriberIdsByTypes = ResourceSubscriptionProvider.getSubscribersOfComponentAndTypedResource(this.getComponentInstanceId(), CalendarSubscriptionConstants.CALENDAR, calendarEvent.getCalendar().getId(), new SubscriberDirective[0]).indexBySubscriberType();
    }

    SubscriberNotificationBuilder(CalendarEventOccurrence occurrence, NotifAction action) {
        super((PlannedOnCalendar)occurrence, action);
        this.subscriberIdsByTypes = ResourceSubscriptionProvider.getSubscribersOfComponentAndTypedResource(this.getComponentInstanceId(), CalendarSubscriptionConstants.CALENDAR, occurrence.getCalendarEvent().getCalendar().getId(), new SubscriberDirective[0]).indexBySubscriberType();
    }

    @Override
    public SubscriberNotificationBuilder from(User sender) {
        return (SubscriberNotificationBuilder)super.from(sender);
    }

    @Override
    public SubscriberNotificationBuilder immediately() {
        return (SubscriberNotificationBuilder)super.immediately();
    }

    @Override
    public SubscriberNotificationBuilder about(CalendarOperation operation) {
        return (SubscriberNotificationBuilder)super.about(operation);
    }

    public SubscriberNotificationBuilder excludingUsersIds(Collection<String> userIdsToExclude) {
        this.userIdsToExclude = userIdsToExclude;
        return this;
    }

    @Override
    protected String getBundleSubjectKey() {
        if (this.getOperation() == CalendarOperation.EVENT_CREATE) {
            return "subject.eventCreate";
        }
        if (this.getOperation() == CalendarOperation.EVENT_UPDATE || this.getOperation() == CalendarOperation.SINCE_EVENT_UPDATE) {
            return "subject.eventUpdate";
        }
        if (this.getOperation() == CalendarOperation.EVENT_DELETION || this.getOperation() == CalendarOperation.SINCE_EVENT_DELETION) {
            return "subject.eventDelete";
        }
        return "subject.default";
    }

    @Override
    protected Collection<String> getUserIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.USER)).getAllIds();
    }

    @Override
    protected Collection<String> getGroupIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.GROUP)).getAllIds();
    }

    @Override
    protected Collection<String> getUserIdsToExcludeFromNotifying() {
        return this.userIdsToExclude;
    }
}

