/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class RightRecover {
    @Inject
    private Administration admin;

    private RightRecover() {
    }

    public void recoverRights() throws AdminException {
        String[] rootSpaceIds;
        for (String spaceId : rootSpaceIds = this.admin.getAllRootSpaceIds()) {
            List<SpaceInstLight> subSpaces = this.admin.getSubSpaces(spaceId);
            for (SpaceInstLight subSpace : subSpaces) {
                this.recoverSpaceRights(subSpace.getId());
            }
        }
    }

    public void recoverSpaceRights(String spaceId) throws AdminException {
        SpaceInst space = this.admin.getSpaceInstById(spaceId);
        if (!space.isRoot()) {
            if (space.isInheritanceBlocked()) {
                List<SpaceProfileInst> profiles = space.getInheritedProfiles();
                if (!profiles.isEmpty()) {
                    SilverLogger.getLogger((Object)this).warn(space.getName() + " does not inherit rights but still had inherit rights", new Object[0]);
                    for (SpaceProfileInst profile : profiles) {
                        this.admin.deleteSpaceProfileInst(profile.getId(), null);
                    }
                }
            } else {
                this.admin.setSpaceProfilesToSubSpace(space, null, true);
            }
        }
        List<SpaceInst> subSpaces = space.getSubSpaces();
        for (SpaceInst aSubSpace : subSpaces) {
            this.recoverSpaceRights(aSubSpace.getId());
        }
        List<ComponentInst> components = space.getAllComponentsInst();
        for (ComponentInst component : components) {
            this.recoverComponentRights(component, space);
        }
    }

    private void recoverComponentRights(ComponentInst component, SpaceInst space) throws AdminException {
        if (component.isInheritanceBlocked()) {
            List<ProfileInst> profiles = component.getInheritedProfiles();
            if (!profiles.isEmpty()) {
                SilverLogger.getLogger((Object)this).warn(component.getLabel() + " does not inherit rights but still had inherit rights", new Object[0]);
                for (ProfileInst profile : profiles) {
                    this.admin.deleteProfileInst(profile.getId(), null);
                }
            }
        } else {
            this.admin.setSpaceProfilesToComponent(component, space);
        }
    }
}

