/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.synchro;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.notification.user.SimpleUserNotification;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;

public class SynchroDomainScheduler
implements SchedulerEventListener {
    private static final String ADMINSYNCHRODOMAIN_JOB_NAME = "AdminSynchroDomainJob";
    private List<String> domainIds = null;

    public void initialize(String cron, List<String> domainIds) {
        try {
            this.domainIds = domainIds;
            Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
            scheduler.unscheduleJob(ADMINSYNCHRODOMAIN_JOB_NAME);
            JobTrigger trigger = JobTrigger.triggerAt((String)cron);
            scheduler.scheduleJob(ADMINSYNCHRODOMAIN_JOB_NAME, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    public void addDomain(String id) {
        if (this.domainIds == null) {
            this.domainIds = new ArrayList<String>();
        }
        this.domainIds.add(id);
    }

    public void removeDomain(String id) {
        if (this.domainIds != null) {
            this.domainIds.remove(id);
        }
    }

    private void doSynchro() {
        if (this.domainIds != null) {
            for (String domainId : this.domainIds) {
                try {
                    AdministrationServiceProvider.getAdminService().synchronizeSilverpeasWithDomain(domainId, true);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
                    OrganizationController organizationController = OrganizationController.get();
                    Domain domain = organizationController.getDomain(domainId);
                    UserDetailsSearchCriteria criteria = new UserDetailsSearchCriteria().onUserStatesToExclude(UserState.BLOCKED, UserState.DEACTIVATED, UserState.REMOVED).onAccessLevels(UserAccessLevel.ADMINISTRATOR);
                    SilverpeasList admins = organizationController.searchUsers(criteria);
                    criteria = new UserDetailsSearchCriteria().onDomainIds(domainId).onUserStatesToExclude(UserState.BLOCKED, UserState.DEACTIVATED, UserState.REMOVED).onAccessLevels(UserAccessLevel.DOMAIN_ADMINISTRATOR);
                    admins.addAll(organizationController.searchUsers(criteria));
                    SimpleUserNotification.fromSystem().toUsers((Collection<User>)admins).withTitle(l -> this.bundle((String)l).getStringWithParams("admin.domain.sync.error.notif.title", new Object[]{domain.getName()})).andMessage(l -> this.bundle((String)l).getStringWithParams("admin.domain.sync.error.notif.message", new Object[]{domain.getName(), e.getMessage()})).send();
                }
            }
        }
    }

    private LocalizationBundle bundle(String locale) {
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.admin.multilang.admin", (String)locale);
    }

    public void triggerFired(SchedulerEvent anEvent) {
        this.doSynchro();
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
    }

    public void jobFailed(SchedulerEvent anEvent) {
        String jobName = anEvent.getJobExecutionContext().getJobName();
        SilverLogger.getLogger((Object)this).error("The domain synchronization job {0} failed!", new Object[]{jobName});
    }
}

