/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.bundle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silverpeas.kernel.util.SystemWrapper;

class VariableResolver {
    private static final Pattern VAR_PATTERN = Pattern.compile(".*(\\$\\{)((env|sys)\\..*)(}).*$");
    private static final Pattern VAR_REPLACEMENT = Pattern.compile("\\$\\{(env|sys)\\..*}");

    private VariableResolver() {
    }

    static Object resolve(Object value) {
        if (value instanceof String) {
            value = VariableResolver.resolve((String)value);
        }
        return value;
    }

    static String resolve(String value) {
        Matcher matching;
        String resolvedValue = value;
        if (value != null && !value.trim().isEmpty() && (matching = VAR_PATTERN.matcher(value)).matches()) {
            String[] statement = matching.group(2).split("\\.");
            String resolution = statement[0].equals("env") ? SystemWrapper.getInstance().getenv(statement[1]) : SystemWrapper.getInstance().getProperty(statement[1]);
            matching = VAR_REPLACEMENT.matcher(value);
            resolvedValue = matching.replaceAll(resolution.replace("\\", "/"));
        }
        return resolvedValue;
    }
}

