/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine;

import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.thread.task.RequestTaskManager;
import org.silverpeas.core.workflow.api.event.QuestionEvent;
import org.silverpeas.core.workflow.api.event.ResponseEvent;
import org.silverpeas.core.workflow.api.event.TaskDoneEvent;
import org.silverpeas.core.workflow.api.event.TaskSavedEvent;
import org.silverpeas.core.workflow.api.event.TimeoutEvent;
import org.silverpeas.core.workflow.engine.AbstractRequest;
import org.silverpeas.core.workflow.engine.QuestionRequest;
import org.silverpeas.core.workflow.engine.ResponseRequest;
import org.silverpeas.core.workflow.engine.TaskDoneRequest;
import org.silverpeas.core.workflow.engine.TaskSavedRequest;
import org.silverpeas.core.workflow.engine.TimeoutRequest;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;

@Technical
@Bean
public class WorkflowEngineTask
extends AbstractRequestTask<AbstractRequestTask.ProcessContext> {
    protected WorkflowEngineTask() {
    }

    public static void addTaskDoneRequest(TaskDoneEvent event) {
        TaskDoneRequest request = TaskDoneRequest.get(event);
        SilverLogger.getLogger(WorkflowEngineTask.class).info("Add task done request: {0}", new Object[]{request.toString()});
        WorkflowEngineTask.push(request);
    }

    public static void addTaskSavedRequest(TaskSavedEvent event) {
        TaskSavedRequest request = TaskSavedRequest.get(event);
        SilverLogger.getLogger(WorkflowEngineTask.class).info("Add task saved request: {0}", new Object[]{request.toString()});
        WorkflowEngineTask.push(request);
    }

    public static void addQuestionRequest(QuestionEvent event) {
        QuestionRequest request = QuestionRequest.get(event);
        SilverLogger.getLogger(WorkflowEngineTask.class).info("Add question request: {0}", new Object[]{request.toString()});
        WorkflowEngineTask.push(request);
    }

    public static void addResponseRequest(ResponseEvent event) {
        ResponseRequest request = ResponseRequest.get(event);
        SilverLogger.getLogger(WorkflowEngineTask.class).info("Add response request: {0}", new Object[]{request.toString()});
        WorkflowEngineTask.push(request);
    }

    public static void addTimeoutRequest(TimeoutEvent event) {
        TimeoutRequest request = TimeoutRequest.get(event);
        SilverLogger.getLogger(WorkflowEngineTask.class).info("Add timeout request: {0}", new Object[]{request.toString()});
        WorkflowEngineTask.push(request);
    }

    private static void push(AbstractRequest request) {
        RequestTaskManager.get().push(WorkflowEngineTask.class, (AbstractRequestTask.Request)request);
    }
}

