/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.validation;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.contribution.ValidableContribution;
import org.silverpeas.core.contribution.model.ContributionValidation;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class ContributionValidationEntity {
    private final ContributionValidation validation;

    public static ContributionValidationEntity fromValidableContribution(ValidableContribution validableContribution) {
        return ContributionValidationEntity.fromContributionValidation(validableContribution.getValidation());
    }

    private static ContributionValidationEntity fromContributionValidation(ContributionValidation validation) {
        return new ContributionValidationEntity(validation);
    }

    @XmlElement
    public ContributionStatus getStatus() {
        return this.validation.getStatus();
    }

    protected void setStatus(ContributionStatus status) {
        this.validation.setStatus(status);
    }

    @XmlTransient
    public boolean isInDraft() {
        return this.getStatus().isInDraft();
    }

    @XmlTransient
    public boolean isRefused() {
        return this.getStatus().isRefused();
    }

    @XmlTransient
    public boolean isPendingValidation() {
        return this.getStatus().isPendingValidation();
    }

    @XmlTransient
    public boolean isValidated() {
        return this.getStatus().isValidated();
    }

    @XmlElement
    public Date getDate() {
        return this.validation.getDate();
    }

    protected void setDate(Date validationDate) {
        this.validation.setDate(validationDate);
    }

    @XmlElement
    public String getComment() {
        return this.validation.getComment();
    }

    protected void setComment(String validationComment) {
        this.validation.setComment(validationComment);
    }

    @XmlElement
    public String getValidatorName() {
        String validatorName = "";
        if (this.validation.getValidator() != null) {
            validatorName = this.validation.getValidator().getDisplayedName();
        }
        return validatorName;
    }

    protected void setValidatorName(String validatorName) {
    }

    @XmlElement
    public String getValidatorId() {
        if (this.validation.getValidator() == null) {
            return null;
        }
        return this.validation.getValidator().getId();
    }

    protected void setValidatorId(String validatorId) {
        this.validation.setValidator((User)UserDetail.getById((String)validatorId));
    }

    public ContributionValidation toContributionValidation() {
        return this.validation;
    }

    protected ContributionValidationEntity() {
        this.validation = new ContributionValidation();
    }

    protected ContributionValidationEntity(ContributionValidation validation) {
        this.validation = validation;
    }

    public String toString() {
        return "ContributionValidationEntity{status=" + this.getStatus() + ", date=" + this.getDate() + ", comment=" + this.getComment() + ", validatorId=" + this.getValidatorId() + "}";
    }
}

