/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.media;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class EmbedMediaPlayerDispatcher {
    private static final String SERVICES_URI = "/services";
    private static final String SERVICES_MEDIA_PLAYER_EMBED_URI = "/services/media/player/embed";
    private static final String EMBED_PLAYER_PARAMETER = "embedPlayer";
    private static final String MEDIA_URL_PARAMETER = "url";
    private static final String MIME_TYPE_PARAMETER = "mimeType";
    private static final String PLAYER_TYPE_PARAMETER = "playerType";
    private static final String CACHE_PARAMETER = "t_";
    private static final Pattern AUDIO_MIME_TYPE_PATTERN = Pattern.compile(".*\\b(audio|mp3|mpeg3|mpeg-3)\\b.*");
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    private EmbedMediaPlayerDispatcher(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public static EmbedMediaPlayerDispatcher from(HttpServletRequest request, HttpServletResponse response) {
        return new EmbedMediaPlayerDispatcher(request, response);
    }

    public boolean dispatchWithSilverpeasFile(SilverpeasFile file) {
        return this.dispatch((File)file, file.getMimeType());
    }

    public Response.ResponseBuilder seeOtherWithSilverpeasFile(SilverpeasFile file) {
        return this.seeOther((File)file, file.getMimeType());
    }

    private boolean dispatch(File fileToSend, String mimeType) {
        String forcedMimeType = this.request.getParameter(MIME_TYPE_PARAMETER);
        String finalMimeType = StringUtil.isDefined((String)forcedMimeType) ? forcedMimeType : mimeType;
        boolean isEmbedPlayerRequested = this.isEmbedPlayerRequested();
        if (isEmbedPlayerRequested) {
            UriBuilder uriBuilder = UriBuilder.fromPath((String)SERVICES_MEDIA_PLAYER_EMBED_URI);
            this.applyCommonParameters(fileToSend, uriBuilder, finalMimeType);
            RequestDispatcher dispatcher = this.request.getRequestDispatcher(uriBuilder.build(new Object[0]).toString());
            try {
                dispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
            }
            catch (IOException | ServletException e) {
                throw new SilverpeasRuntimeException(e);
            }
        }
        return isEmbedPlayerRequested;
    }

    private Response.ResponseBuilder seeOther(File fileToSend, String mimeType) {
        String finalMimeType;
        String forcedMimeType = this.request.getParameter(MIME_TYPE_PARAMETER);
        String string = finalMimeType = StringUtil.isDefined((String)forcedMimeType) ? forcedMimeType : mimeType;
        if (this.isEmbedPlayerRequested()) {
            UriBuilder uriBuilder = UriBuilder.fromPath((String)SERVICES_MEDIA_PLAYER_EMBED_URI.substring(SERVICES_URI.length()));
            this.copyParametersFromRequest(uriBuilder);
            this.applyCommonParameters(fileToSend, uriBuilder, finalMimeType);
            return Response.seeOther((URI)uriBuilder.build(new Object[0]));
        }
        return null;
    }

    private void applyCommonParameters(File fileToSend, UriBuilder uriBuilder, String finalMimeType) {
        UriBuilder mediaUriBuilder = UriBuilder.fromPath((String)this.request.getRequestURI());
        this.copyParametersFromRequest(mediaUriBuilder);
        this.setCacheParameter(fileToSend, mediaUriBuilder);
        uriBuilder.replaceQueryParam(MEDIA_URL_PARAMETER, new Object[]{mediaUriBuilder.build(new Object[0]).toString()});
        uriBuilder.replaceQueryParam(MIME_TYPE_PARAMETER, new Object[]{finalMimeType});
        uriBuilder.replaceQueryParam(PLAYER_TYPE_PARAMETER, new Object[]{this.getPlayerType(finalMimeType)});
        this.setCacheParameter(fileToSend, uriBuilder);
    }

    private void copyParametersFromRequest(UriBuilder uriBuilder) {
        Enumeration params = this.request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            if (EMBED_PLAYER_PARAMETER.equals(paramName) || "_".equals(paramName)) continue;
            uriBuilder.queryParam(paramName, new Object[]{this.request.getParameter(paramName)});
        }
    }

    private void setCacheParameter(File fileToSend, UriBuilder mediaUriBuilder) {
        mediaUriBuilder.replaceQueryParam(CACHE_PARAMETER, new Object[]{fileToSend.lastModified()});
    }

    private boolean isEmbedPlayerRequested() {
        return StringUtil.getBooleanValue((String)this.request.getParameter(EMBED_PLAYER_PARAMETER));
    }

    private String getPlayerType(String mimeType) {
        String playerType = this.request.getParameter(PLAYER_TYPE_PARAMETER);
        if (StringUtil.isNotDefined((String)playerType)) {
            playerType = AUDIO_MIME_TYPE_PATTERN.matcher(mimeType).matches() ? "audio" : "video";
        }
        return playerType;
    }
}

