/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.calendar;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.CalendarEventUtil;
import org.silverpeas.core.webapi.calendar.CalendarEventAttendeeEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventAttributeEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventEntity;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CalendarEventOccurrenceEntity
extends CalendarEventEntity {
    private URI occurrenceUri;
    private URI occurrenceViewUrl;
    private URI occurrenceEditionUrl;
    private URI occurrencePermalinkUrl;
    private String occurrenceId;
    private String originalStartDate;
    private boolean firstEventOccurrence;

    protected CalendarEventOccurrenceEntity() {
    }

    public static CalendarEventOccurrenceEntity fromOccurrence(CalendarEventOccurrence occurrence, String componentInstanceId, ZoneId zoneId, boolean isEditionMode) {
        return new CalendarEventOccurrenceEntity().decorate(occurrence, componentInstanceId, zoneId, isEditionMode);
    }

    public static String decodeId(String occurrenceId) {
        return new String(StringUtil.fromBase64((String)occurrenceId));
    }

    public CalendarEventOccurrenceEntity withOccurrenceViewURL(URI occurrenceViewUrl) {
        this.setOccurrenceViewUrl(occurrenceViewUrl);
        return this;
    }

    public CalendarEventOccurrenceEntity withOccurrenceEditionURL(URI occurrenceEditionUrl) {
        this.setOccurrenceEditionUrl(occurrenceEditionUrl);
        return this;
    }

    public CalendarEventOccurrenceEntity withOccurrencePermalinkURL(URI permalinkUrl) {
        this.occurrencePermalinkUrl = permalinkUrl;
        return this;
    }

    public CalendarEventOccurrenceEntity withOccurrenceURI(URI occurrenceUri) {
        this.occurrenceUri = occurrenceUri;
        return this;
    }

    @Override
    public CalendarEventOccurrenceEntity withEventURI(URI eventUri) {
        super.withEventURI(eventUri);
        return this;
    }

    @Override
    public CalendarEventOccurrenceEntity withCalendarURI(URI calendarUri) {
        super.withCalendarURI(calendarUri);
        return this;
    }

    @Override
    public CalendarEventOccurrenceEntity withEventPermalinkURL(URI permalinkUrl) {
        super.withEventPermalinkURL(permalinkUrl);
        return this;
    }

    @Override
    public CalendarEventOccurrenceEntity withAttendees(List<CalendarEventAttendeeEntity> attendees) {
        super.withAttendees(attendees);
        return this;
    }

    @Override
    public CalendarEventOccurrenceEntity withAttributes(List<CalendarEventAttributeEntity> attributes) {
        super.withAttributes(attributes);
        return this;
    }

    @Override
    @XmlElement(defaultValue="")
    public URI getURI() {
        return this.getOccurrenceUri();
    }

    public URI getOccurrenceUri() {
        return this.occurrenceUri;
    }

    protected void setOccurrenceUri(URI occurrenceUri) {
        this.occurrenceUri = occurrenceUri;
    }

    public URI getOccurrenceViewUrl() {
        return this.occurrenceViewUrl;
    }

    public void setOccurrenceViewUrl(URI occurrenceViewUrl) {
        this.occurrenceViewUrl = occurrenceViewUrl;
    }

    public URI getOccurrenceEditionUrl() {
        return this.occurrenceEditionUrl;
    }

    public void setOccurrenceEditionUrl(URI occurrenceEditionUrl) {
        this.occurrenceEditionUrl = occurrenceEditionUrl;
    }

    public URI getOccurrencePermalinkUrl() {
        return this.occurrencePermalinkUrl;
    }

    public void setOccurrencePermalinkUrl(URI occurrencePermalinkUrl) {
        this.occurrencePermalinkUrl = occurrencePermalinkUrl;
    }

    public String getOccurrenceId() {
        return this.occurrenceId;
    }

    public void setOccurrenceId(String occurrenceId) {
        this.occurrenceId = occurrenceId;
    }

    public String getOriginalStartDate() {
        return this.originalStartDate;
    }

    public void setOriginalStartDate(String originalStartDate) {
        this.originalStartDate = originalStartDate;
    }

    public boolean isFirstEventOccurrence() {
        return this.firstEventOccurrence;
    }

    protected void setFirstEventOccurrence(boolean firstEventOccurrence) {
        this.firstEventOccurrence = firstEventOccurrence;
    }

    @XmlTransient
    CalendarEventOccurrence getMergedOccurrence() {
        CalendarEventOccurrence occurrence = CalendarEventOccurrence.getById((String)CalendarEventOccurrenceEntity.decodeId(this.getOccurrenceId())).orElse(null);
        if (occurrence == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.applyOn(occurrence.getCalendarEvent());
        this.applyOn(occurrence.asCalendarComponent());
        return occurrence;
    }

    protected CalendarEventOccurrenceEntity decorate(CalendarEventOccurrence calendarEventOccurrence, String componentInstanceId, ZoneId zoneId, boolean isEditionMode) {
        CalendarEvent calEvent = calendarEventOccurrence.getCalendarEvent();
        this.decorate(calEvent, calEvent.getCalendar().getComponentInstanceId(), zoneId, isEditionMode);
        this.setId(calendarEventOccurrence.getIdentifier().asString());
        this.setContributionType(calendarEventOccurrence.getContributionType());
        this.occurrenceId = StringUtil.asBase64((byte[])calendarEventOccurrence.getId().getBytes());
        this.originalStartDate = calendarEventOccurrence.getOriginalStartDate().toString();
        this.setFirstEventOccurrence(calendarEventOccurrence.getOriginalStartDate().equals(calendarEventOccurrence.getCalendarEvent().getStartDate()));
        CalendarComponent component = calendarEventOccurrence.asCalendarComponent();
        this.setOnAllDay(calendarEventOccurrence.isOnAllDay());
        this.setStartDate(CalendarEventUtil.formatDateWithOffset((CalendarComponent)component, (Temporal)calendarEventOccurrence.getStartDate(), (ZoneId)zoneId));
        this.setEndDate(CalendarEventUtil.formatDateWithOffset((CalendarComponent)component, (Temporal)calendarEventOccurrence.getEndDate(), (ZoneId)zoneId));
        if (component.getLastUpdateDate() != null) {
            this.setLastUpdateDate(component.getLastUpdateDate());
            this.setLastUpdatedById(component.getLastUpdaterId());
        }
        this.setTitle(CalendarEventUtil.formatTitle((CalendarComponent)component, (String)componentInstanceId, (boolean)this.canBeAccessed()));
        if (this.canBeAccessed()) {
            this.setDescription(component.getDescription());
            this.setLocation(component.getLocation());
            this.setPriority(component.getPriority());
        }
        return this;
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        ToStringBuilder builder = super.toStringBuilder();
        builder.append("occurrenceId", (Object)this.getOccurrenceId());
        builder.append("calendarZoneId", (Object)this.getCalendarZoneId());
        builder.append("originalStartDate", (Object)this.getOriginalStartDate());
        builder.append("firstEventOccurrence", this.isFirstEventOccurrence());
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarEventOccurrenceEntity that = (CalendarEventOccurrenceEntity)o;
        return new EqualsBuilder().append((Object)this.occurrenceId, (Object)that.occurrenceId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.occurrenceId).toHashCode();
    }
}

