/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin.scim;

import edu.psu.swe.scim.server.exception.UnableToCreateResourceException;
import edu.psu.swe.scim.server.exception.UnableToDeleteResourceException;
import edu.psu.swe.scim.server.exception.UnableToRetrieveResourceException;
import edu.psu.swe.scim.server.exception.UnableToUpdateResourceException;
import edu.psu.swe.scim.server.provider.Provider;
import edu.psu.swe.scim.server.provider.UpdateRequest;
import edu.psu.swe.scim.spec.extension.EnterpriseExtension;
import edu.psu.swe.scim.spec.protocol.filter.FilterResponse;
import edu.psu.swe.scim.spec.protocol.search.Filter;
import edu.psu.swe.scim.spec.protocol.search.PageRequest;
import edu.psu.swe.scim.spec.protocol.search.SortRequest;
import edu.psu.swe.scim.spec.resources.ScimExtension;
import edu.psu.swe.scim.spec.resources.ScimUser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.webapi.admin.scim.AbstractScimAdminService;
import org.silverpeas.core.webapi.admin.scim.PatchOperationApplier;
import org.silverpeas.core.webapi.admin.scim.ScimLogger;
import org.silverpeas.core.webapi.admin.scim.SilverpeasScimServerConverter;
import org.silverpeas.core.webapi.profile.UserProfilesSearchCriteriaBuilder;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ScimUserAdminService
extends AbstractScimAdminService
implements Provider<ScimUser> {
    public ScimUser create(ScimUser resource) throws UnableToCreateResourceException {
        ScimLogger.logger().debug(() -> "creating user " + resource);
        this.validateDomainExists();
        try {
            UserFull user = SilverpeasScimServerConverter.convert(resource);
            user.setDomainId(this.scimRequestContext.getDomainId());
            if (StringUtil.isNotDefined((String)user.getLastName())) {
                ScimLogger.logger().debug(() -> "using 'UserName' SCIM attribute for user last name");
                user.setLastName(resource.getUserName());
            }
            user.setAccessLevel(UserAccessLevel.USER);
            String newSpUserId = this.admin.addUser((UserDetail)user);
            user.setId(newSpUserId);
            return SilverpeasScimServerConverter.convert((User)user);
        }
        catch (Exception e) {
            Domain domain;
            try {
                domain = Administration.get().getDomain(this.scimRequestContext.getDomainId());
            }
            catch (AdminException ae) {
                throw new UnableToCreateResourceException(Response.Status.FORBIDDEN, ae.getMessage());
            }
            throw new UnableToCreateResourceException(domain.isQuotaReached() ? Response.Status.FORBIDDEN : Response.Status.NOT_FOUND, e.getMessage());
        }
    }

    public ScimUser update(UpdateRequest<ScimUser> updateRequest) throws UnableToUpdateResourceException {
        ScimUser resource;
        try {
            resource = (ScimUser)updateRequest.getResource();
        }
        catch (UnsupportedOperationException e) {
            resource = null;
        }
        if (resource != null) {
            ScimLogger.logger().debug(() -> "updating user " + updateRequest.getOriginal());
            this.validateDomainExists();
            try {
                UserFull user = this.getUserById(updateRequest.getId());
                SilverpeasScimServerConverter.applyTo(resource, user);
                return this.update(user);
            }
            catch (Exception e) {
                throw new UnableToUpdateResourceException(Response.Status.NOT_FOUND, e.getMessage());
            }
        }
        ScimLogger.logger().debug(() -> "patching user " + updateRequest.getOriginal());
        this.validateDomainExists();
        if (CollectionUtil.isEmpty((Collection)updateRequest.getPatchOperations())) {
            throw new UnableToUpdateResourceException(Response.Status.BAD_REQUEST, "no attribute to patch");
        }
        try {
            ScimUser scimUser = (ScimUser)updateRequest.getOriginal();
            PatchOperationApplier operationApplier = new PatchOperationApplier(scimUser);
            updateRequest.getPatchOperations().forEach(operationApplier::apply);
            UserFull user = this.getUserById(updateRequest.getId());
            SilverpeasScimServerConverter.applyTo(scimUser, user);
            return this.update(user);
        }
        catch (Exception e) {
            throw new UnableToUpdateResourceException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }

    private ScimUser update(UserFull updatedUser) throws UnableToUpdateResourceException {
        if (StringUtil.isNotDefined((String)updatedUser.getLastName())) {
            ScimLogger.logger().debug(() -> "using 'UserName' SCIM attribute for user last name");
            updatedUser.setLastName(updatedUser.getLogin());
        }
        try {
            this.admin.updateUser((UserDetail)updatedUser);
            return SilverpeasScimServerConverter.convert((User)updatedUser);
        }
        catch (AdminException e) {
            throw new UnableToUpdateResourceException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }

    public ScimUser get(String id) throws UnableToRetrieveResourceException {
        ScimLogger.logger().debug(() -> "getting user by id " + id);
        this.validateDomainExists();
        try {
            UserFull user = this.getUserById(id);
            return SilverpeasScimServerConverter.convert((User)user);
        }
        catch (Exception e) {
            throw new UnableToRetrieveResourceException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }

    public FilterResponse<ScimUser> find(Filter filter, PageRequest pageRequest, SortRequest sortRequest) throws UnableToRetrieveResourceException {
        String domainId = this.scimRequestContext.getDomainId();
        ScimLogger.logger().debug(() -> "looking for users into domain " + domainId + " by filtering on " + filter);
        this.validateDomainExists();
        try {
            int itemPerPage;
            UserProfilesSearchCriteriaBuilder criteriaBuilder = UserProfilesSearchCriteriaBuilder.aSearchCriteria().withDomainIds(domainId);
            int startIndex = pageRequest.getStartIndex() != null ? pageRequest.getStartIndex() : 0;
            int n = itemPerPage = pageRequest.getCount() != null ? pageRequest.getCount() : 10;
            if (startIndex > 0) {
                criteriaBuilder.withPaginationPage(new PaginationPage((startIndex - 1) / itemPerPage + 1, itemPerPage));
            }
            SilverpeasList users = this.admin.searchUsers(this.processExpression(filter.getExpression(), criteriaBuilder.build()));
            FilterResponse response = new FilterResponse();
            response.setResources((Collection)users.stream().map(SilverpeasScimServerConverter::convert).collect(Collectors.toList()));
            if (users.originalListSize() > 0L) {
                PageRequest paginationResult = new PageRequest();
                paginationResult.setStartIndex(Integer.valueOf(startIndex > 0 ? startIndex : 1));
                paginationResult.setCount(Integer.valueOf(startIndex > 0 ? itemPerPage : (int)users.originalListSize()));
                response.setPageRequest(paginationResult);
            }
            response.setTotalResults((int)users.originalListSize());
            ScimLogger.logger().debug(() -> "finding " + users.originalListSize() + " user(s)");
            return response;
        }
        catch (Exception e) {
            throw new UnableToRetrieveResourceException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }

    public void delete(String id) throws UnableToDeleteResourceException {
        ScimLogger.logger().debug(() -> "deleting user by id " + id);
        this.validateDomainExists();
        try {
            UserFull user = this.getUserById(id);
            this.admin.deleteUser(user.getId());
        }
        catch (Exception e) {
            throw new UnableToDeleteResourceException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }

    public List<Class<? extends ScimExtension>> getExtensionList() {
        ScimLogger.logger().debug(() -> "getting user SCIM extensions");
        return Collections.singletonList(EnterpriseExtension.class);
    }

    private UserFull getUserById(String id) throws AdminException {
        UserFull user = this.admin.getUserFull(SilverpeasScimServerConverter.decodeUserId(id));
        if (!this.scimRequestContext.getDomainId().equals(user.getDomainId())) {
            throw new AdminException("trying to manage a user of a forbidden domain!", new String[0]);
        }
        return user;
    }
}

