/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin.scim;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.webapi.admin.scim.ScimLogger;

public class ScimServerFilter
implements Filter {
    public static final String PUSH_SILVERPEAS_AUTHORIZED_ADMIN_IDS_PROP_KEY = "push.silverpeas.authorized.admin.ids";
    private static final Pattern SCIM_PATH_PATTERN = Pattern.compile("/domains/{domainId}/scim".replace("{domainId}", "[0-9]+"));

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            HttpRequest httpRequest = HttpRequest.decorate((ServletRequest)request);
            if (SCIM_PATH_PATTERN.matcher(httpRequest.getRequestURI()).find()) {
                ScimLogger.logger().debug(() -> MessageFormat.format("handling {0} on {1} from SCIM client {2}", httpRequest.getMethod(), httpRequest.getRequestURI(), httpRequest.getRemoteHost()));
                chain.doFilter(request, response);
                if (httpResponse.getStatus() >= 400) {
                    ScimLogger.logger().error("error {0} - {1}", new Object[]{httpResponse.getStatus(), Response.Status.fromStatusCode((int)httpResponse.getStatus())});
                } else {
                    ScimLogger.logger().debug(() -> MessageFormat.format("status {0} - {1}", httpResponse.getStatus(), Response.Status.fromStatusCode((int)httpResponse.getStatus())));
                }
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

