/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.buttons;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.buttons.Button;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractButton
implements Button {
    private static final Pattern ACTION_JS_DETECTION = Pattern.compile("(?i)^(\\s*([a-z]+)\\s*:\\s*([a-z]+)\\s*=\\s*)");
    public String label;
    private String action;
    public boolean disabled;
    private String actionPreProcessing;
    private String classes = "";

    @Override
    public void init(String label, String action, boolean disabled) {
        this.label = label;
        this.action = action;
        this.disabled = disabled;
    }

    public String getIconsPath() {
        return GraphicElementFactory.getIconsPath();
    }

    @Override
    public void setRootImagePath(String s) {
    }

    @Override
    public final String print() {
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isDefined((String)this.actionPreProcessing)) {
            Object theAction = this.action;
            Object javascriptSpecif = "";
            Matcher javascriptMatcher = ACTION_JS_DETECTION.matcher(this.action);
            if (javascriptMatcher.find()) {
                theAction = ((String)theAction).substring(javascriptMatcher.group(1).length());
                javascriptSpecif = javascriptMatcher.group(2) + ":" + javascriptMatcher.group(3) + "=";
            } else {
                theAction = "jQuery('<form>', {'method':'GET', 'action':'" + (String)theAction + "'}).submit();";
                theAction = this.unEscapeForMessageFormatting((String)theAction);
                javascriptSpecif = "javascript:onClick=";
            }
            String tempActionPreProcessing = this.escapeForMessageFormatting(this.actionPreProcessing);
            tempActionPreProcessing = MessageFormat.format(tempActionPreProcessing.replace("'", "''").replace("@#<#@action@#>#@", "{0}"), theAction);
            tempActionPreProcessing = this.unEscapeForMessageFormatting(tempActionPreProcessing);
            script actionPreProcessFunction = new script().setType("text/javascript");
            actionPreProcessFunction.addElement("function handleButtonAction() {\n");
            actionPreProcessFunction.addElement(tempActionPreProcessing);
            actionPreProcessFunction.addElement("\n}");
            sb.append(actionPreProcessFunction.toString()).append("\n");
            this.action = (String)javascriptSpecif + "handleButtonAction();";
        }
        sb.append(this.renderButtonHtml());
        return sb.toString();
    }

    protected abstract String renderButtonHtml();

    @Override
    public void setActionPreProcessing(String actionPreProcessing) {
        this.actionPreProcessing = actionPreProcessing;
    }

    @Override
    public void setClasses(String classes) {
        this.classes = StringUtil.defaultStringIfNotDefined((String)classes);
    }

    protected String getAction() {
        return this.action;
    }

    protected String getClasses() {
        return this.classes;
    }

    private String escapeForMessageFormatting(String jsContent) {
        String escapedJsContent = this.actionPreProcessing.replaceAll("[{]", "@#<#@");
        return escapedJsContent.replaceAll("[}]", "@#>#@");
    }

    private String unEscapeForMessageFormatting(String escapedJsContent) {
        String jsContent = escapedJsContent.replaceAll("@#<#@", "{");
        return jsContent.replaceAll("@#>#@", "}");
    }
}

