/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.servlet;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.SyndFeedOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class RssServlet<T>
extends HttpServlet {
    private static final long serialVersionUID = 1756308502037077021L;
    private static final int DEFAULT_MAX_TEMS_COUNT = 15;
    private static final String NOTHING = "";
    @Inject
    private AdminController adminController;
    @Inject
    private OrganizationController organizationController;

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        String instanceId = this.getObjectId(req);
        String userId = this.getUserId(req);
        String login = this.getLogin(req);
        String password = this.getPassword(req);
        if (this.isComponentRss(instanceId)) {
            try {
                UserFull user = this.adminController.getUserFull(userId);
                if (user != null && login.equals(user.getLogin()) && password.equals(user.getPassword()) && this.isComponentAvailable(instanceId, userId)) {
                    String serverURL = this.getServerURL(this.adminController, user.getDomainId());
                    SyndFeedImpl feed = new SyndFeedImpl();
                    feed.setFeedType("rss_2.0");
                    feed.setTitle(this.getChannelTitle(instanceId));
                    feed.setDescription(this.getChannelTitle(instanceId));
                    feed.setLink(serverURL + URLUtil.getApplicationURL() + URLUtil.getURL((String)"useless", (String)instanceId));
                    int nbReturnedElements = this.getNbReturnedElements();
                    Collection<T> listElements = this.getListElements(instanceId, nbReturnedElements);
                    ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>(listElements.size());
                    for (T element : listElements) {
                        String title2 = this.getElementTitle(element, userId);
                        String link2 = serverURL + this.getElementLink(element, userId);
                        String description = this.getElementDescription(element, userId);
                        Date dateElement = this.getElementDate(element);
                        String creatorId = this.getElementCreatorId(element);
                        SyndEntryImpl entry = new SyndEntryImpl();
                        SyndContentImpl descriptionContent = new SyndContentImpl();
                        descriptionContent.setType("text/plain");
                        descriptionContent.setValue(description);
                        entry.setTitle(title2);
                        entry.setLink(link2);
                        entry.setDescription((SyndContent)descriptionContent);
                        entry.setPublishedDate(dateElement);
                        this.setCreator(element, creatorId, (SyndEntry)entry);
                        entries.add(entry);
                    }
                    feed.setEntries(entries);
                    res.setContentType("application/rss+xml");
                    PrintWriter writer = res.getWriter();
                    SyndFeedOutput feedOutput = new SyndFeedOutput();
                    feedOutput.output((SyndFeed)feed, (Writer)writer);
                } else {
                    this.objectNotFound(req, res);
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
                this.objectNotFound(req, res);
            }
        }
    }

    protected void setCreator(T element, String creatorId, SyndEntry entry) {
        if (StringUtil.isDefined((String)creatorId)) {
            UserDetail creator = this.adminController.getUserDetail(creatorId);
            if (creator != null) {
                entry.setAuthor(creator.getDisplayedName());
            }
        } else if (StringUtil.isDefined((String)this.getExternalCreatorId(element))) {
            entry.setAuthor(this.getExternalCreatorId(element));
        }
    }

    public String getChannelTitle(String instanceId) {
        ComponentInstLight instance = this.organizationController.getComponentInstLight(instanceId);
        if (instance != null) {
            return instance.getLabel();
        }
        return NOTHING;
    }

    public String getServerURL(AdminController admin, String domainId) {
        Domain defaultDomain = admin.getDomain(domainId);
        return defaultDomain.getSilverpeasServerURL();
    }

    public boolean isComponentRss(String instanceId) {
        String paramRssValue = this.organizationController.getComponentParameterValue(instanceId, "rss");
        return "yes".equalsIgnoreCase(paramRssValue);
    }

    public boolean isComponentAvailable(String instanceId, String userId) {
        return this.adminController.isComponentAvailable(instanceId, userId);
    }

    public int getNbReturnedElements() {
        return 15;
    }

    public abstract Collection<T> getListElements(String var1, int var2) throws RemoteException;

    public abstract String getElementTitle(T var1, String var2);

    public abstract String getElementLink(T var1, String var2);

    public abstract String getElementDescription(T var1, String var2);

    public abstract Date getElementDate(T var1);

    public abstract String getElementCreatorId(T var1);

    public String getExternalCreatorId(T element) {
        return NOTHING;
    }

    protected String getObjectId(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            return pathInfo.substring(1);
        }
        return null;
    }

    protected String getUserId(HttpServletRequest request) {
        return request.getParameter("userId");
    }

    protected String getLogin(HttpServletRequest request) {
        return request.getParameter("login");
    }

    protected String getPassword(HttpServletRequest request) {
        return request.getParameter("password");
    }

    protected MainSessionController getMainSessionController(HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        return (MainSessionController)session.getAttribute("SilverSessionController");
    }

    protected boolean isUserLogin(HttpServletRequest req) {
        return this.getMainSessionController(req) != null;
    }

    protected void objectNotFound(HttpServletRequest req, HttpServletResponse res) {
        try {
            boolean isLoggedIn = this.isUserLogin(req);
            if (!isLoggedIn) {
                res.sendRedirect("/weblib/notFound.html");
            } else {
                res.sendRedirect(URLUtil.getApplicationURL() + "/admin/jsp/documentNotFound.jsp");
            }
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            res.setStatus(500);
        }
    }
}

