/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class WysiwygEditorConfig {
    private static final SettingBundle DEFAULT_WYSIWYG_SETTINGS = ResourceLocator.getSettingBundle((String)"org.silverpeas.wysiwyg.settings.wysiwygSettings");
    private SettingBundle wysiwygSettings;
    private String height = "500";
    private String width = "100%";
    private String language = I18NHelper.DEFAULT_LANGUAGE;
    private String toolbar = "Default";
    private boolean toolbarStartExpanded = true;
    private boolean fileBrowserDisplayed = true;
    private String skin = DEFAULT_WYSIWYG_SETTINGS.getString("skin", "");
    private String stylesheet;
    private String componentId;
    private String objectId;

    public WysiwygEditorConfig(String componentName) {
        Optional settings = StringUtil.isDefined((String)componentName) ? ResourceLocator.getOptionalSettingBundle((String)("org.silverpeas.wysiwyg.settings." + componentName + "Settings")) : Optional.empty();
        this.wysiwygSettings = settings.orElse(DEFAULT_WYSIWYG_SETTINGS);
    }

    private WysiwygEditorConfig(WysiwygEditorConfig config) {
        this.wysiwygSettings = config.wysiwygSettings;
        this.height = config.height;
        this.width = config.width;
        this.language = config.language;
        this.toolbar = config.toolbar;
        this.toolbarStartExpanded = config.toolbarStartExpanded;
        this.fileBrowserDisplayed = config.fileBrowserDisplayed;
        this.skin = config.skin;
        this.stylesheet = config.stylesheet;
        this.componentId = config.componentId;
        this.objectId = config.objectId;
    }

    public String toJSON() {
        return JSONCodec.encodeObject(builder -> {
            JSONCodec.JSONObject object = builder.put("height", this.getHeight()).put("width", this.getWidth()).put("language", this.getLanguage()).put("baseHref", this.getServerURL()).put("toolbarStartupExpanded", Boolean.valueOf(this.isToolbarStartExpanded())).put("customConfig", this.getConfigFile()).put("toolbar", this.getToolbar()).put("imagebank", Boolean.valueOf(true)).put("filebank", Boolean.valueOf(true)).put("silverpeasObjectId", this.getObjectId()).put("silverpeasComponentId", this.getComponentId());
            object = this.putFileBrowserUrls(object);
            object = this.putSkin(object);
            object = this.putCustomStylesheets(object);
            return object;
        });
    }

    private JSONCodec.JSONObject putCustomStylesheets(JSONCodec.JSONObject object) {
        JSONCodec.JSONObject json = object;
        List<String> stylesheets = this.getStylesheets();
        if (!stylesheets.isEmpty()) {
            json = object.putJSONArray("contentsCss", a2 -> a2.addJSONArray(stylesheets));
        }
        return json;
    }

    private JSONCodec.JSONObject putSkin(JSONCodec.JSONObject object) {
        JSONCodec.JSONObject json = object;
        if (StringUtil.isDefined((String)this.getSkin())) {
            json = object.put("skin", this.getSkin());
        }
        return json;
    }

    private JSONCodec.JSONObject putFileBrowserUrls(JSONCodec.JSONObject object) {
        JSONCodec.JSONObject json = object;
        if (!this.isFileBrowserDisplayed()) {
            json = object.put("filebrowserImageBrowseUrl", "").put("filebrowserFlashBrowseUrl", "").put("filebrowserBrowseUrl", "").put("imageUploadUrl", "");
        } else if (this.getComponentId() == null || this.getComponentId().startsWith("webSites") && StringUtil.isLong((String)this.objectId)) {
            json = object.put("imageUploadUrl", "");
        }
        return json;
    }

    public List<String> getStylesheets() {
        boolean isStylesheetCanBeSet;
        ArrayList<String> stylesheets = new ArrayList<String>();
        boolean bl = isStylesheetCanBeSet = !this.wysiwygSettings.getBoolean("noCss", false);
        if (isStylesheetCanBeSet) {
            stylesheets.add(URLUtil.addFingerprintVersionOn((String)(URLUtil.getApplicationURL() + "/util/styleSheets/silverpeas-main.css")));
            if (StringUtil.isDefined((String)this.stylesheet)) {
                stylesheets.add(URLUtil.addFingerprintVersionOn((String)this.stylesheet));
            }
        }
        return stylesheets;
    }

    public String getSkin() {
        return this.skin;
    }

    private String getConfigFile() {
        Object configFile = this.wysiwygSettings.getString("configFile");
        if (!((String)configFile).startsWith("/") && !((String)configFile).toLowerCase().startsWith("http")) {
            configFile = URLUtil.getApplicationURL() + "/" + (String)configFile;
        }
        return URLUtil.addFingerprintVersionOn((String)configFile);
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(String toolbar) {
        this.toolbar = toolbar;
    }

    public void setStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    private boolean isToolbarStartExpanded() {
        return this.toolbarStartExpanded;
    }

    public void setToolbarStartExpanded(boolean toolbarStartExpanded) {
        this.toolbarStartExpanded = toolbarStartExpanded;
    }

    public String getServerURL() {
        return ResourceLocator.getGeneralSettingBundle().getString("httpServerBase", URLUtil.getCurrentServerURL());
    }

    private boolean isFileBrowserDisplayed() {
        return this.fileBrowserDisplayed;
    }

    public void setFileBrowserDisplayed(boolean fileBrowserDisplayed) {
        this.fileBrowserDisplayed = fileBrowserDisplayed;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public WysiwygEditorConfig copy() {
        WysiwygEditorConfig clone = new WysiwygEditorConfig(this);
        clone.wysiwygSettings = this.wysiwygSettings;
        return clone;
    }
}

