/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.tools.agenda.notification;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.personalorganizer.model.Attendee;
import org.silverpeas.core.personalorganizer.model.JournalHeader;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.util.StringUtil;

public class AgendaUserNotification
extends AbstractTemplateUserNotificationBuilder<JournalHeader> {
    private SilverpeasCalendar calendarBm;
    private final NotifAction action;
    private final UserDetail sender;
    private final String attend;

    public AgendaUserNotification(NotifAction action, UserDetail sender, JournalHeader resource) {
        this(action, sender, resource, null);
    }

    public AgendaUserNotification(UserDetail sender, JournalHeader resource, String attend) {
        this(NotifAction.RESPONSE, sender, resource, attend);
    }

    private AgendaUserNotification(NotifAction action, UserDetail sender, JournalHeader resource, String attend) {
        super((Object)resource);
        this.action = action;
        this.sender = sender;
        this.attend = attend;
    }

    protected void initialize() {
        super.initialize();
        this.getNotificationMetaData().setSource(this.getBundle(this.sender.getUserPreferences().getLanguage()).getString("agenda"));
    }

    protected String getBundleSubjectKey() {
        String subjectKey;
        switch (this.action) {
            case UPDATE: {
                subjectKey = "titleUpdate";
                break;
            }
            case DELETE: {
                subjectKey = "titleDelete";
                break;
            }
            case RESPONSE: {
                subjectKey = "titleAttend";
                break;
            }
            default: {
                subjectKey = "titleCreate";
            }
        }
        return subjectKey;
    }

    protected String getTemplateFileName() {
        String fileName;
        switch (this.action) {
            case UPDATE: {
                fileName = "updateEvent";
                break;
            }
            case DELETE: {
                fileName = "deleteEvent";
                break;
            }
            case RESPONSE: {
                fileName = "eventAttendeeResponse";
                break;
            }
            default: {
                fileName = "addEvent";
            }
        }
        return fileName;
    }

    protected Collection<String> getUserIdsToNotify() {
        HashSet<String> userIds;
        if (this.action == NotifAction.RESPONSE) {
            userIds = Collections.singleton(((JournalHeader)this.getResource()).getDelegatorId());
        } else {
            userIds = new HashSet();
            for (Attendee attendee : this.getSilverpeasCalendar().getJournalAttendees(((JournalHeader)this.getResource()).getId())) {
                userIds.add(attendee.getUserId());
            }
        }
        return userIds;
    }

    protected void performTemplateData(String language, JournalHeader resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getTitle(language), "");
        template.setAttribute("sender", (Object)this.sender.getDisplayedName());
        if (StringUtil.isDefined((String)this.attend)) {
            template.setAttribute(this.attend, (Object)this.attend);
        }
        template.setAttribute("name", (Object)Encode.forHtml((String)((JournalHeader)this.getResource()).getName()));
        template.setAttribute("startDate", (Object)DateUtil.getOutputDate((Date)((JournalHeader)this.getResource()).getStartDate(), (String)language));
        if (StringUtil.isDefined((String)((JournalHeader)this.getResource()).getStartHour())) {
            template.setAttribute("startHour", (Object)((JournalHeader)this.getResource()).getStartHour());
        }
    }

    protected void performNotificationResource(String language, JournalHeader resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getName());
    }

    protected String getResourceURL(JournalHeader resource) {
        StringBuilder sb = new StringBuilder(URLUtil.getURL((String)"agenda", null, null));
        sb.append("journal.jsp?JournalId=");
        sb.append(resource.getId());
        sb.append("&Action=");
        if (this.action == NotifAction.DELETE) {
            return null;
        }
        sb.append("Update");
        return sb.toString();
    }

    protected String getTemplatePath() {
        return "agenda";
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return "";
    }

    protected String getSender() {
        return this.sender.getId();
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.agenda.multilang.agenda";
    }

    protected boolean isSendImmediately() {
        return true;
    }

    protected SilverpeasCalendar getSilverpeasCalendar() {
        if (this.calendarBm == null) {
            this.calendarBm = (SilverpeasCalendar)ServiceProvider.getService(SilverpeasCalendar.class, (Annotation[])new Annotation[0]);
        }
        return this.calendarBm;
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "agenda.notifEventLinkLabel";
    }
}

