/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.look;

import org.silverpeas.core.web.look.LayoutConfiguration;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class DefaultLayoutConfiguration
implements LayoutConfiguration {
    private SettingBundle settings;
    private String headerURL;
    private String bodyURL;
    private String bodyNavigationURL;

    public DefaultLayoutConfiguration(SettingBundle settings) {
        this.settings = settings;
    }

    @Override
    public String getHeaderURL() {
        return StringUtil.defaultStringIfNotDefined((String)this.headerURL, (String)this.settings.getString("layout.header.url", "/admin/jsp/silverpeas-header-part.jsp"));
    }

    @Override
    public boolean isHeaderToggleFade() {
        return this.settings.getBoolean("layout.header.toggle.fade", false);
    }

    @Override
    public String getBodyURL() {
        return StringUtil.defaultStringIfNotDefined((String)this.bodyURL, (String)this.settings.getString("layout.body.url", "/admin/jsp/silverpeas-body-part.jsp"));
    }

    @Override
    public String getBodyNavigationURL() {
        return StringUtil.defaultStringIfNotDefined((String)this.bodyNavigationURL, (String)this.settings.getString("layout.body.navigation.url", "/admin/jsp/silverpeas-navigation-part.jsp"));
    }

    @Override
    public boolean isBodyNavigationFade() {
        return this.settings.getBoolean("layout.body.navigation.toggle.fade", false);
    }

    public void setHeaderURL(String url) {
        this.headerURL = url;
    }

    public void setBodyURL(String url) {
        this.bodyURL = url;
    }

    public void setBodyNavigationURL(String url) {
        this.bodyNavigationURL = url;
    }
}

