/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication;

import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

public class LogoutServlet
extends HttpServlet {
    private static final long serialVersionUID = 996291597161289526L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            SettingBundle resource;
            Object postLogoutPage;
            HttpSession session = request.getSession(false);
            if (session != null) {
                SessionManagementProvider.getSessionManagement().closeSession(session.getId());
                this.invalidateUserSession(session);
            }
            if (((String)(postLogoutPage = (resource = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.settings.authenticationSettings")).getString("logout.page", "/Login?logout=true"))).startsWith("http")) {
                response.sendRedirect((String)postLogoutPage);
                return;
            }
            StringBuilder buffer = new StringBuilder(512);
            buffer.append(request.getScheme()).append("://").append(request.getServerName()).append(':');
            buffer.append(request.getServerPort()).append(request.getContextPath());
            User currentUser = User.getCurrentRequester();
            if (currentUser != null) {
                String paramDelimiter = ((String)postLogoutPage).contains("?") ? "&" : "?";
                postLogoutPage = (String)postLogoutPage + paramDelimiter + "DomainId=" + currentUser.getDomainId();
            }
            buffer.append((String)postLogoutPage);
            response.sendRedirect(response.encodeRedirectURL(buffer.toString()));
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            response.setStatus(500);
        }
    }

    private void invalidateUserSession(HttpSession session) {
        try {
            session.invalidate();
        }
        catch (IllegalStateException e) {
            SilverLogger.getLogger((Object)((Object)this)).silent((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }
}

