/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.invoker;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelState;
import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.container.ChannelURLType;
import com.sun.portal.container.Container;
import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerFactory;
import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContainerType;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.EntityID;
import com.sun.portal.container.ErrorCode;
import com.sun.portal.container.ExecuteActionRequest;
import com.sun.portal.container.ExecuteActionResponse;
import com.sun.portal.container.GetMarkupRequest;
import com.sun.portal.container.GetMarkupResponse;
import com.sun.portal.container.GetResourceRequest;
import com.sun.portal.container.GetResourceResponse;
import com.sun.portal.container.PortletWindowContext;
import com.sun.portal.container.PortletWindowContextAbstractFactory;
import com.sun.portal.container.PortletWindowContextException;
import com.sun.portal.container.PortletWindowContextFactory;
import com.sun.portal.container.WindowRequestReader;
import com.sun.portal.portletcontainer.invoker.InvokerException;
import com.sun.portal.portletcontainer.invoker.ResponseProperties;
import com.sun.portal.portletcontainer.invoker.WindowErrorCode;
import com.sun.portal.portletcontainer.invoker.WindowException;
import com.sun.portal.portletcontainer.invoker.WindowInvokerConstants;
import com.sun.portal.portletcontainer.invoker.util.InvokerUtil;
import com.sun.portal.portletcontainer.invoker.util.PortletWindowRules;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

public abstract class WindowInvoker
implements WindowInvokerConstants {
    private static final String ERROR_CODE = "errorCode";
    public static final List localParamKeyList = WindowInvoker.initParamKeyList();
    private String title = "";
    private HttpServletRequest origRequest;
    private HttpServletResponse origResponse;
    private PortletWindowContext portletWindowContext;
    private String portletWindowName;
    private ChannelMode portletWindowMode;
    private ChannelState portletWindowState;
    private ServletContext servletContext;
    private ResponseProperties responseProperties;
    private static final Logger logger = ContainerLogger.getLogger(WindowInvoker.class, (String)"org.silverpeas.portlets.PCCTXLogMessages");

    public abstract List getRoleList(HttpServletRequest var1) throws InvokerException;

    public abstract Map getUserInfoMap(HttpServletRequest var1) throws InvokerException;

    public abstract EntityID getEntityID(HttpServletRequest var1) throws InvokerException;

    public abstract WindowRequestReader getWindowRequestReader() throws InvokerException;

    public abstract Container getContainer();

    public abstract ChannelURLFactory getPortletWindowURLFactory(String var1, HttpServletRequest var2) throws InvokerException;

    public abstract boolean isMarkupSupported(String var1, String var2, ChannelMode var3, ChannelState var4) throws InvokerException;

    public abstract String getDefaultTitle() throws InvokerException;

    public void init(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws InvokerException {
        this.origRequest = request;
        this.origResponse = response;
        this.servletContext = servletContext;
        try {
            PortletWindowContextAbstractFactory afactory = new PortletWindowContextAbstractFactory();
            PortletWindowContextFactory factory = afactory.getPortletWindowContextFactory();
            this.portletWindowContext = factory.getPortletWindowContext(request);
        }
        catch (PortletWindowContextException pwce) {
            throw new InvokerException("Initialization of WindowInvoker failed", pwce);
        }
    }

    public String getPortletWindowName() {
        return this.portletWindowName;
    }

    public void setPortletWindowName(String portletWindowName) {
        this.portletWindowName = portletWindowName;
    }

    protected HttpServletRequest getOriginalRequest() {
        return this.origRequest;
    }

    protected HttpServletResponse getOriginalResponse() {
        return this.origResponse;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    public ChannelMode getPortletWindowMode() {
        return this.portletWindowMode;
    }

    public void setPortletWindowMode(ChannelMode portletWindowMode) {
        this.portletWindowMode = portletWindowMode;
    }

    public ChannelState getPortletWindowState() {
        return this.portletWindowState;
    }

    public void setPortletWindowState(ChannelState portletWindowState) {
        this.portletWindowState = portletWindowState;
    }

    public StringBuffer render(HttpServletRequest request, HttpServletResponse response) throws InvokerException {
        StringBuffer markupText = null;
        ErrorCode errorCode = this.readErrorCode(request);
        if (errorCode != null) {
            logger.log(Level.FINE, "PSPL_PCCTXCSPPCI0001", errorCode);
            markupText = this.getErrorMessageContent(errorCode);
            this.setTitle(this.getDefaultTitle());
        } else {
            try {
                markupText = this.getPortletContent(request, response);
            }
            catch (WindowException we) {
                logger.log(Level.SEVERE, "PSPL_PCCTXCSPPCI0006", we.getMessage());
                markupText = this.getErrorMessageContent(we.getErrorCode());
            }
            catch (InvokerException ie) {
                logger.log(Level.SEVERE, "PSPL_PCCTXCSPPCI0006", ie.getMessage());
                markupText = this.getErrorMessageContent(WindowErrorCode.CONTAINER_EXCEPTION);
            }
        }
        return markupText;
    }

    private StringBuffer getPortletContent(HttpServletRequest request, HttpServletResponse response) throws InvokerException, WindowException {
        boolean authless = this.getPortletWindowContext().isAuthless(request);
        EntityID portletEntityId = this.getEntityID(request);
        ChannelMode currentPortletWindowMode = this.getCurrentPortletWindowMode(request);
        ChannelState currentWindowState = this.getCurrentWindowState(request);
        List allowableWindowStates = this.getAllowableWindowStates(request, currentPortletWindowMode);
        List<ChannelMode> allowablePortletWindowModes = PortletWindowRules.getAllowablePortletWindowModes(currentPortletWindowMode, authless);
        String processURL = this.getActionURL(request, currentPortletWindowMode, currentWindowState);
        GetMarkupRequest getMarkupRequest = this.getContainer().createGetMarkUpRequest(request, portletEntityId, currentWindowState, currentPortletWindowMode, this.portletWindowContext, this.getPortletWindowURLFactory(processURL, request));
        this.populateContainerRequest((ContainerRequest)getMarkupRequest, request, allowableWindowStates, allowablePortletWindowModes);
        GetMarkupResponse getMarkupResponse = this.getContainer().createGetMarkUpResponse(response);
        try {
            this.getContainer().getMarkup(getMarkupRequest, getMarkupResponse);
        }
        catch (ContainerException ce) {
            this.setTitle(this.getDefaultTitle());
            if (logger.isLoggable(Level.WARNING)) {
                LogRecord logRecord = new LogRecord(Level.WARNING, "PSPL_PCCTXCSPPCI0006");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{this.getPortletWindowName()});
                logRecord.setThrown(ce);
                logger.log(logRecord);
            }
            throw new InvokerException("Container exception", ce);
        }
        catch (ContentException cte) {
            this.setTitle(this.getDefaultTitle());
            if (logger.isLoggable(Level.WARNING)) {
                LogRecord logRecord = new LogRecord(Level.WARNING, "PSPL_PCCTXCSPPCI0006");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{this.getPortletWindowName()});
                logRecord.setThrown(cte);
                logger.log(logRecord);
            }
            throw new WindowException(this.getErrorCode(cte), "Content Exception", cte);
        }
        this.setTitle(getMarkupResponse.getTitle());
        if (getMarkupResponse.getMarkup() == null) {
            logger.info("PSPL_PCCTXCSPPCI0007");
        }
        if (getMarkupResponse.getCookieProperties() != null || getMarkupResponse.getStringProperties() != null || getMarkupResponse.getElementProperties() != null) {
            this.responseProperties = new ResponseProperties();
            this.responseProperties.setCookies(getMarkupResponse.getCookieProperties());
            this.responseProperties.setResponseHeaders(getMarkupResponse.getStringProperties());
            this.responseProperties.setMarkupHeaders(getMarkupResponse.getElementProperties());
        }
        return getMarkupResponse.getMarkup();
    }

    public URL processAction(HttpServletRequest request, HttpServletResponse response) throws InvokerException {
        try {
            return this.processActionInternal(request, response);
        }
        catch (WindowException we) {
            logger.log(Level.SEVERE, "PSPL_PCCTXCSPPCI0008", we.getMessage());
            return this.getErrorCodeURL(we.getErrorCode(), request);
        }
    }

    public URL processActionInternal(HttpServletRequest request, HttpServletResponse response) throws InvokerException, WindowException {
        URL returnURL = null;
        ChannelMode currentPortletWindowMode = null;
        ChannelMode newPortletWindowMode = null;
        ChannelState currentWindowState = null;
        ChannelState newWindowState = null;
        boolean authless = this.getPortletWindowContext().isAuthless(request);
        EntityID portletEntityId = this.getEntityID(request);
        currentPortletWindowMode = this.getCurrentPortletWindowMode(request);
        currentWindowState = this.getCurrentWindowState(request);
        newWindowState = this.getWindowRequestReader().readNewWindowState(request);
        newPortletWindowMode = this.getWindowRequestReader().readNewPortletWindowMode(request);
        if (newPortletWindowMode != null) {
            this.validateModeChange(currentPortletWindowMode, newPortletWindowMode, authless);
            currentPortletWindowMode = newPortletWindowMode;
        }
        if (newWindowState != null) {
            currentWindowState = this.processWindowStateChange(request, newWindowState, currentPortletWindowMode, authless);
        }
        ChannelURLType urlType = this.getWindowRequestReader().readURLType(request);
        Container c = ContainerFactory.getContainer((ContainerType)ContainerType.PORTLET_CONTAINER);
        String processURL = this.getActionURL(request, currentPortletWindowMode, currentWindowState);
        ExecuteActionRequest executeActionRequest = this.getContainer().createExecuteActionRequest(request, portletEntityId, currentWindowState, currentPortletWindowMode, this.portletWindowContext, this.getPortletWindowURLFactory(processURL, request), this.getWindowRequestReader());
        List allowableWindowStates = this.getAllowableWindowStates(request, currentPortletWindowMode);
        List<ChannelMode> allowablePortletWindowModes = PortletWindowRules.getAllowablePortletWindowModes(currentPortletWindowMode, authless);
        this.populateContainerRequest((ContainerRequest)executeActionRequest, request, allowableWindowStates, allowablePortletWindowModes);
        ExecuteActionResponse executeActionResponse = this.getContainer().createExecuteActionResponse(response);
        try {
            this.getContainer().executeAction(executeActionRequest, executeActionResponse, urlType);
        }
        catch (ContainerException ce) {
            if (logger.isLoggable(Level.WARNING)) {
                LogRecord logRecord = new LogRecord(Level.WARNING, "PSPL_PCCTXCSPPCI0008");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{this.getPortletWindowName()});
                logRecord.setThrown(ce);
                logger.log(logRecord);
            }
            throw new InvokerException("WindowInvoker.processAction():container exception", ce);
        }
        catch (ContentException cte) {
            if (logger.isLoggable(Level.WARNING)) {
                LogRecord logRecord = new LogRecord(Level.WARNING, "PSPL_PCCTXCSPPCI0008");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{this.getPortletWindowName()});
                logRecord.setThrown(cte);
                logger.log(logRecord);
            }
            throw new WindowException(this.getErrorCode(cte), "Content Exception", cte);
        }
        returnURL = executeActionResponse.getRedirectURL();
        if (returnURL == null) {
            newPortletWindowMode = executeActionResponse.getNewChannelMode();
            if (newPortletWindowMode != null) {
                this.validateModeChange(currentPortletWindowMode, newPortletWindowMode, authless);
                currentPortletWindowMode = newPortletWindowMode;
            }
            if ((newWindowState = executeActionResponse.getNewWindowState()) != null) {
                currentWindowState = this.processWindowStateChange(request, newWindowState, currentPortletWindowMode, authless);
            }
        }
        if (returnURL == null && currentPortletWindowMode != null) {
            returnURL = this.processModeChange(request, currentPortletWindowMode, currentWindowState);
        }
        return returnURL;
    }

    public void getResources(HttpServletRequest request, HttpServletResponse response) throws InvokerException {
        try {
            this.getResourcesInternal(request, response);
        }
        catch (WindowException we) {
            logger.log(Level.SEVERE, "PSPL_PCCTXCSPPCI0019", we.getMessage());
        }
    }

    public void getResourcesInternal(HttpServletRequest request, HttpServletResponse response) throws InvokerException, WindowException {
        boolean authless = this.getPortletWindowContext().isAuthless(request);
        EntityID portletEntityId = this.getEntityID(request);
        ChannelMode currentPortletWindowMode = this.getCurrentPortletWindowMode(request);
        ChannelState currentWindowState = this.getCurrentWindowState(request);
        List allowableWindowStates = this.getAllowableWindowStates(request, currentPortletWindowMode);
        List<ChannelMode> allowablePortletWindowModes = PortletWindowRules.getAllowablePortletWindowModes(currentPortletWindowMode, authless);
        String processURL = this.getActionURL(request, currentPortletWindowMode, currentWindowState);
        GetResourceRequest getResourceRequest = this.getContainer().createGetResourceRequest(request, portletEntityId, currentWindowState, currentPortletWindowMode, this.portletWindowContext, this.getPortletWindowURLFactory(processURL, request), this.getWindowRequestReader());
        this.populateContainerRequest((ContainerRequest)getResourceRequest, request, allowableWindowStates, allowablePortletWindowModes);
        GetResourceResponse getResourceResponse = this.getContainer().createGetResourceResponse(response);
        try {
            this.getContainer().getResources(getResourceRequest, getResourceResponse);
        }
        catch (ContainerException ce) {
            this.setTitle(this.getDefaultTitle());
            if (logger.isLoggable(Level.WARNING)) {
                LogRecord logRecord = new LogRecord(Level.WARNING, "PSPL_PCCTXCSPPCI0019");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{this.getPortletWindowName()});
                logRecord.setThrown(ce);
                logger.log(logRecord);
            }
            throw new InvokerException("Container exception", ce);
        }
        catch (ContentException cte) {
            this.setTitle(this.getDefaultTitle());
            if (logger.isLoggable(Level.WARNING)) {
                LogRecord logRecord = new LogRecord(Level.WARNING, "PSPL_PCCTXCSPPCI0019");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{this.getPortletWindowName()});
                logRecord.setThrown(cte);
                logger.log(logRecord);
            }
            throw new InvokerException("Container exception");
        }
        if (getResourceResponse.getCookieProperties() != null || getResourceResponse.getStringProperties() != null || getResourceResponse.getElementProperties() != null) {
            this.responseProperties = new ResponseProperties();
            this.responseProperties.setCookies(getResourceResponse.getCookieProperties());
            this.responseProperties.setResponseHeaders(getResourceResponse.getStringProperties());
            this.responseProperties.setMarkupHeaders(getResourceResponse.getElementProperties());
        }
        InvokerUtil.setResponseProperties(request, response, this.responseProperties);
        try {
            StringBuffer buff = getResourceResponse.getContentAsBuffer();
            byte[] bytes = getResourceResponse.getContentAsBytes();
            if (buff != null) {
                response.getWriter().print(buff);
            } else if (bytes != null && bytes.length > 0) {
                response.getOutputStream().write(bytes);
            } else {
                response.getWriter().print("");
            }
            response.flushBuffer();
            InvokerUtil.clearResponseProperties(this.responseProperties);
        }
        catch (IOException e) {
            throw new InvokerException("Exception in Writing Response", e);
        }
    }

    protected void populateContainerRequest(ContainerRequest containerRequest, HttpServletRequest request, List allowableWindowStates, List allowablePortletWindowModes) throws InvokerException {
        containerRequest.setAllowableWindowStates(allowableWindowStates);
        containerRequest.setAllowableChannelModes(allowablePortletWindowModes);
        String contentType = this.getPortletWindowContext().getContentType();
        ArrayList<String> allowableContentTypes = new ArrayList<String>();
        allowableContentTypes.add(contentType);
        containerRequest.setAllowableContentTypes(allowableContentTypes);
        containerRequest.setRoles(this.getRoleList(request));
        containerRequest.setUserInfo(this.getUserInfoMap(request));
    }

    public String getTitle() throws InvokerException {
        if (this.title != null && this.title.trim().length() != 0) {
            return this.title;
        }
        return this.getDefaultTitle();
    }

    public ResponseProperties getResponseProperties() {
        return this.responseProperties;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isEditable() throws InvokerException {
        if (this.getPortletWindowContext().isAuthless(this.origRequest)) {
            return false;
        }
        return this.isMarkupSupported(this.getPortletWindowContext().getContentType(), this.getPortletWindowContext().getLocaleString(), ChannelMode.EDIT, ChannelState.MAXIMIZED);
    }

    protected ChannelState processWindowStateChange(HttpServletRequest request, ChannelState newWindowState, ChannelMode portletWindowMode, boolean authless) throws InvokerException, WindowException {
        ChannelState windowState = newWindowState;
        boolean validState = PortletWindowRules.validateWindowStateChange(portletWindowMode, newWindowState);
        if (!validState || newWindowState == null) {
            windowState = PortletWindowRules.getDefaultWindowState(portletWindowMode);
            logger.log(Level.FINER, "PSPL_PCCTXCSPPCI0002", new Object[]{windowState, portletWindowMode});
        }
        return windowState;
    }

    protected URL processModeChange(HttpServletRequest request, ChannelMode portletWindowMode, ChannelState portletWindowState) throws InvokerException {
        URL redirectURL = null;
        try {
            redirectURL = new URL(this.getRenderURL(request, portletWindowMode, portletWindowState));
        }
        catch (MalformedURLException mue) {
            throw new InvokerException("WindowInvoker.processModeChange(): couldn't generate redirect URL to page for mode " + portletWindowMode.toString(), mue);
        }
        return redirectURL;
    }

    private static List<String> initParamKeyList() {
        ArrayList<String> paramKeyList = new ArrayList<String>();
        paramKeyList.add("pc.portletId");
        paramKeyList.add("pc.portletMode");
        return paramKeyList;
    }

    public static boolean isWindowInvokerKey(String key) {
        return key != null && localParamKeyList.contains(key);
    }

    public URL getErrorCodeURL(ErrorCode errorCode, HttpServletRequest request) throws InvokerException {
        try {
            String startURL = this.getPortletWindowContext().getDesktopURL(request) + "?";
            return new URL(startURL + this.getErrorCodeParameter() + "=" + errorCode.toString());
        }
        catch (MalformedURLException mue) {
            throw new InvokerException("WindowInvoker.getErrorCodeURL():couldn't build errorURL", mue);
        }
    }

    private String getErrorCodeParameter() {
        StringBuilder builder = new StringBuilder();
        builder.append("pc.");
        builder.append(this.getPortletWindowName());
        builder.append(ERROR_CODE);
        return builder.toString();
    }

    protected StringBuffer getErrorMessageContent(ErrorCode errorCode) {
        ResourceBundle bundle = null;
        StringBuffer buffer = new StringBuffer();
        try {
            bundle = this.getResourceBundle("org.silverpeas.portlets.multilang.WindowInvoker");
            buffer.append(bundle.getString(errorCode.toString()));
        }
        catch (MissingResourceException ex) {
            logger.log(Level.FINE, "PSPL_PCCTXCSPPCI0003", ex);
            if (bundle != null) {
                buffer.append(bundle.getString(WindowErrorCode.GENERIC_ERROR.toString()));
                buffer.append(" ");
                buffer.append(errorCode);
            }
            buffer.append(WindowErrorCode.GENERIC_ERROR.toString());
            buffer.append(" ");
            buffer.append(errorCode);
        }
        return buffer;
    }

    protected ErrorCode getErrorCode(ContentException ex) {
        ErrorCode code = ex.getErrorCode();
        if (code == null) {
            return WindowErrorCode.CONTENT_EXCEPTION;
        }
        return code;
    }

    protected ErrorCode readErrorCode(HttpServletRequest request) {
        String errorCodeStr = request.getParameter(this.getErrorCodeParameter());
        if (errorCodeStr != null && errorCodeStr.length() > 0) {
            return new ErrorCode(errorCodeStr);
        }
        return null;
    }

    protected ChannelMode getCurrentPortletWindowMode(HttpServletRequest request) {
        ChannelMode currentPortletWindowMode = this.getPortletWindowMode();
        if (currentPortletWindowMode != null) {
            return currentPortletWindowMode;
        }
        return ChannelMode.VIEW;
    }

    protected ChannelState getCurrentWindowState(HttpServletRequest request) throws InvokerException {
        ChannelState currentWindowState = this.getPortletWindowState();
        if (currentWindowState == null) {
            return PortletWindowRules.getDefaultWindowState(this.getCurrentPortletWindowMode(request));
        }
        return currentWindowState;
    }

    protected List getAllowableWindowStates(HttpServletRequest request, ChannelMode mode) {
        List<ChannelState> allowableWindowStates = null;
        allowableWindowStates = PortletWindowRules.getDefaultAllowableWindowStates(mode);
        return allowableWindowStates;
    }

    public String getActionURL(HttpServletRequest request, ChannelMode portletWindowMode, ChannelState portletWindowState) {
        return this.computeURL(request, "ACTION", portletWindowState, portletWindowMode);
    }

    public String getRenderURL(HttpServletRequest request, ChannelMode portletWindowMode, ChannelState portletWindowState) {
        return this.computeURL(request, "RENDER", portletWindowState, portletWindowMode);
    }

    private String computeURL(HttpServletRequest request, String driverAction, ChannelState portletWindowState, ChannelMode portletWindowMode) {
        String portletWindowStateName = this.getPortletWindowState().toString();
        if (portletWindowState != null) {
            portletWindowStateName = portletWindowState.toString();
        }
        String portletWindowModeName = this.getPortletWindowMode().toString();
        if (portletWindowMode != null) {
            portletWindowModeName = portletWindowMode.toString();
        }
        StringBuilder processURL = new StringBuilder(this.getPortletWindowContext().getDesktopURL(request));
        processURL.append("?").append("dt.driverAction").append("=").append(driverAction).append("&").append("pc.portletMode").append("=").append(portletWindowModeName).append("&").append("pc.windowState").append("=").append(portletWindowStateName).append("&").append("pc.portletId").append("=").append(this.getPortletWindowName());
        String spaceId = (String)request.getAttribute("SpaceId");
        if (StringUtil.isDefined((String)spaceId)) {
            processURL.append("&").append("dt.SpaceId").append("=").append(spaceId);
            processURL.append("&").append("dt.Role").append("=").append("admin");
        }
        return processURL.toString();
    }

    private void validateModeChange(ChannelMode currentMode, ChannelMode newMode, boolean authless) throws WindowException {
        List<ChannelMode> allowedList = PortletWindowRules.getAllowablePortletWindowModes(currentMode, authless);
        if (!allowedList.contains(newMode)) {
            throw new WindowException(WindowErrorCode.INVALID_MODE_CHANGE_REQUEST, "Portal doesn't allow changing mode  from " + currentMode + " to " + newMode);
        }
    }

    public PortletWindowContext getPortletWindowContext() {
        return this.portletWindowContext;
    }

    public ResourceBundle getResourceBundle(String base) {
        return ResourceLocator.getLocalizationBundle((String)base, (String)this.getPortletWindowContext().getLocaleString());
    }
}

