/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.mbeans;

import com.sun.portal.container.PortletLang;
import com.sun.portal.portletcontainer.admin.PortletRegistryGenerator;
import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.PortletUndeployerInfo;
import com.sun.portal.portletcontainer.admin.deployment.WebAppDeployer;
import com.sun.portal.portletcontainer.admin.deployment.WebAppDeployerException;
import com.sun.portal.portletcontainer.admin.deployment.WebAppDeployerFactory;
import com.sun.portal.portletcontainer.admin.mbeans.PortletAdminMBean;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import com.sun.portal.portletcontainer.warupdater.PortletWarUpdater;
import com.sun.portal.portletcontainer.warupdater.PortletWarUpdaterUtil;
import java.io.File;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletAdmin
implements PortletAdminMBean {
    private static Logger logger = Logger.getLogger(PortletAdmin.class.getPackage().getName(), "org.silverpeas.portlets.PALogMessages");

    private boolean preparePortlet(String warFileName) throws Exception {
        logger.log(Level.INFO, "PSPL_CSPPAM0031", warFileName);
        String warFileLocation = PortletRegistryHelper.getWarFileLocation();
        String configFileLocation = PortletRegistryHelper.getConfigFileLocation();
        PortletWarUpdater portletWarUpdater = new PortletWarUpdater(configFileLocation);
        return portletWarUpdater.preparePortlet(new File(warFileName), warFileLocation);
    }

    private Boolean registerPortlet(String warFile, Properties roles, Properties userinfo, File preparedWarFile) throws Exception {
        String typeOfPortlet;
        Attributes attributes;
        String warName = PortletWarUpdaterUtil.getWarName((String)warFile);
        String warFileLocation = PortletRegistryHelper.getWarFileLocation();
        String destFile = warFileLocation + File.separator + warName;
        logger.log(Level.FINE, "PSPL_CSPPAM0001", destFile);
        PortletRegistryGenerator portletRegistryGenerator = new PortletRegistryGenerator();
        JarFile jarFile = new JarFile(warFile);
        Manifest manifest = jarFile.getManifest();
        PortletLang portletLanguage = PortletLang.JAVA;
        if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (typeOfPortlet = attributes.getValue("Portlet-Type")) != null && typeOfPortlet.equalsIgnoreCase("ror")) {
            portletLanguage = PortletLang.ROR;
        }
        logger.log(Level.FINE, "PSPL_CSPPAM0033", portletLanguage.toString());
        portletRegistryGenerator.register(preparedWarFile, warFileLocation, roles, userinfo, portletLanguage);
        logger.log(Level.FINE, "PSPL_CSPPAM0004", warName);
        return Boolean.TRUE;
    }

    @Override
    public Boolean deploy(String warFileName, Properties roles, Properties userinfo, boolean deployToContainer) throws Exception {
        String warName = PortletWarUpdaterUtil.getWarName((String)warFileName);
        boolean prepareSuccess = this.preparePortlet(warFileName);
        Boolean registerSuccess = Boolean.FALSE;
        if (prepareSuccess) {
            File preparedWarFile = new File(warFileName);
            registerSuccess = this.registerPortlet(warFileName, roles, userinfo, preparedWarFile);
        }
        if (registerSuccess.booleanValue()) {
            if (deployToContainer) {
                WebAppDeployer webAppDeployer = WebAppDeployerFactory.getInstance().getDeploymentManager();
                if (webAppDeployer != null) {
                    webAppDeployer.deploy(warName);
                } else {
                    throw new WebAppDeployerException("No WebAppDeployer Found");
                }
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean unregisterPortlet(String warFileName) throws Exception {
        logger.log(Level.INFO, "PSPL_CSPPAM0032", warFileName);
        String warFileLocation = PortletRegistryHelper.getWarFileLocation();
        String configFileLocation = PortletRegistryHelper.getConfigFileLocation();
        PortletRegistryGenerator portletRegistryGenerator = new PortletRegistryGenerator();
        String warName = PortletWarUpdaterUtil.getWarName((String)warFileName);
        logger.log(Level.FINE, "PSPL_CSPPAM0012", warName);
        Boolean value = portletRegistryGenerator.unregister(configFileLocation, warFileLocation, warName);
        if (value.booleanValue()) {
            try {
                PortletUndeployerInfo portletUndeployerInfo = new PortletUndeployerInfo();
                portletUndeployerInfo.write(warName);
            }
            catch (PortletRegistryException pre) {
                logger.log(Level.WARNING, "PSPL_CSPPAM0028", pre);
            }
            boolean remove = this.deletePortlet(warName, warFileLocation);
            portletRegistryGenerator.removePortletWar(warFileLocation, warName);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean undeploy(String warFileName, boolean undeployFromContainer) throws Exception {
        Boolean value = this.unregisterPortlet(warFileName);
        if (value.booleanValue()) {
            if (undeployFromContainer) {
                WebAppDeployer webAppDeployer = WebAppDeployerFactory.getInstance().getDeploymentManager();
                if (webAppDeployer != null) {
                    String warName = PortletWarUpdaterUtil.getWarName((String)warFileName);
                    boolean success = webAppDeployer.undeploy(warName);
                    if (!success) {
                        value = Boolean.FALSE;
                        throw new WebAppDeployerException("Cannot undeploy");
                    }
                } else {
                    value = Boolean.FALSE;
                    logger.log(Level.WARNING, "PSPL_CSPPAM0026");
                    throw new WebAppDeployerException("No WebAppDeployer Found");
                }
            }
            value = Boolean.TRUE;
        }
        return value;
    }

    public void copyFile(String sourceFile, String destFile) throws Exception {
        PortletWarUpdaterUtil.copyFile((String)sourceFile, (String)destFile);
    }

    public boolean deletePortlet(String warNameOnly, String warFileLocation) {
        String warName = warNameOnly + ".war";
        File destFile = new File(warFileLocation, warName);
        boolean remove = destFile.delete();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSPL_CSPPCWU0011", new String[]{destFile.getAbsolutePath(), String.valueOf(remove)});
        }
        return remove;
    }
}

