/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.interests.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.pdc.interests.model.Interests;
import org.silverpeas.core.pdc.interests.service.InterestsDAO;
import org.silverpeas.core.pdc.interests.service.InterestsDAOException;
import org.silverpeas.core.pdc.interests.service.InterestsRuntimeException;
import org.silverpeas.core.pdc.interests.service.InterestsService;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.security.authorization.ForbiddenRuntimeException;

@Service
@Singleton
@Transactional
public class DefaultInterestsService
implements InterestsService {
    @Override
    public List<Interests> getInterestsByUserId(int userID) {
        List<Interests> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                list = InterestsDAO.getInterestsByUserID(con, userID);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | InterestsDAOException e) {
                    throw new InterestsRuntimeException("DefaultInterestsService.getInterestsByUserId()", "Pdc.CANNOT_GET_INTEREST_CENTERS", String.valueOf(userID), (Exception)e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public Interests getInterestsById(int id) {
        Interests interests;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                interests = InterestsDAO.getInterestsByPK(con, id);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | InterestsDAOException e) {
                    throw new InterestsRuntimeException("DefaultInterestsService.getInterestsByPK()", "Interests.CANNOT_LOAD_LIST_OF_IC", String.valueOf(id), (Exception)e);
                }
            }
            con.close();
        }
        return interests;
    }

    @Override
    public int createInterests(Interests interests) {
        int n;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                n = InterestsDAO.saveInterests(con, interests);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | InterestsDAOException e) {
                    throw new InterestsRuntimeException("DefaultInterestsService.createInterests()", "Pdc.CANNOT_CREATE_INTEREST_CENTER", interests.toString(), (Exception)e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public void updateInterests(Interests interests) {
        try (Connection con = DBUtil.openConnection();){
            InterestsDAO.updateInterests(con, interests);
        }
        catch (SQLException | InterestsDAOException e) {
            throw new InterestsRuntimeException("DefaultInterestsService.updateInterests()", "Pdc.CANNOT_UPDATE_INTEREST_CENTER", interests.toString(), (Exception)e);
        }
    }

    @Override
    public void removeInterestsById(List<Integer> ids, String userId) {
        try (Connection con = DBUtil.openConnection();){
            int userIdInt = Integer.parseInt(userId);
            for (Integer icPk : ids) {
                Interests interests = this.getInterestsById(icPk);
                if (userIdInt == interests.getOwnerID()) continue;
                throw new ForbiddenRuntimeException("Unauthorized to remove the interest " + icPk + " of user " + userId);
            }
            InterestsDAO.removeInterestsByPK(con, ids);
        }
        catch (SQLException | InterestsDAOException e) {
            throw new InterestsRuntimeException("DefaultInterestsService.removeInterestsById(ArrayList pks)", "Pdc.CANNOT_DELETE_INTEREST_CENTERS", ids.toString(), (Exception)e);
        }
    }

    @Override
    public void removeInterestsById(int id) {
        try (Connection con = DBUtil.openConnection();){
            InterestsDAO.removeInterestsByPK(con, id);
        }
        catch (SQLException | InterestsDAOException e) {
            throw new InterestsRuntimeException("DefaultInterestsService.removeInterestsById(int pk)", "Pdc.CANNOT_DELETE_INTEREST_CENTER", String.valueOf(id), (Exception)e);
        }
    }
}

