/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chat.listeners;

import java.util.stream.Stream;
import javax.inject.Inject;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.chat.servers.ChatServer;
import org.silverpeas.core.chat.servers.DefaultChatServer;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.socialnetwork.relationship.RelationShip;
import org.silverpeas.core.socialnetwork.relationship.RelationShipEvent;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Service
public class RelationShipListener
extends CDIResourceEventListener<RelationShipEvent> {
    @Inject
    @DefaultChatServer
    private ChatServer server;

    public void onCreation(RelationShipEvent event) {
        User uf2;
        RelationShip rs = (RelationShip)event.getTransition().getAfter();
        User uf1 = User.getById((String)String.valueOf(rs.getUser1Id()));
        if (this.isRelationshipMappable(uf1, uf2 = User.getById((String)String.valueOf(rs.getUser2Id())))) {
            this.server.createRelationShip(uf1, uf2);
            this.logger.debug("Chat relationship between {0} and {1} has been created", new Object[]{uf1.getId(), uf2.getId()});
        } else {
            this.logger.debug("No chat relationship can be created between user {0} and {1}", new Object[]{uf1.getId(), uf2.getId()});
        }
    }

    public void onDeletion(RelationShipEvent event) {
        User uf2;
        RelationShip rs = (RelationShip)event.getTransition().getBefore();
        User uf1 = User.getById((String)String.valueOf(rs.getUser1Id()));
        if (this.isRelationshipMappable(uf1, uf2 = User.getById((String)String.valueOf(rs.getUser2Id())))) {
            this.server.deleteRelationShip(uf1, uf2);
            this.logger.debug("Chat relationship between {0} and {1} has been deleted", new Object[]{uf1.getId(), uf2.getId()});
        } else {
            this.logger.debug("No chat relationship can be deleted between user {0} and {1}", new Object[]{uf1.getId(), uf2.getId()});
        }
    }

    public boolean isEnabled() {
        return ChatServer.isEnabled();
    }

    private boolean isRelationshipMappable(User uf1, User uf2) {
        return Stream.of(uf1, uf2).filter(u -> {
            boolean domainMapped = this.server.isUserDomainSupported(u.getDomainId());
            if (!domainMapped) {
                this.logger.debug("No chat relationship can be handled for user {0} as its domain is not mapped with a chat server", new Object[]{u.getId()});
            }
            return domainMapped;
        }).count() == 2L;
    }
}

