/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contact.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.contact.model.CompleteContact;
import org.silverpeas.core.contact.model.Contact;
import org.silverpeas.core.contact.model.ContactDetail;
import org.silverpeas.core.contact.model.ContactFatherDetail;
import org.silverpeas.core.contact.model.ContactPK;
import org.silverpeas.core.contact.model.ContactRuntimeException;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.util.DateUtil;

@Repository
public class ContactDAO {
    private static final String DELETE_FROM = "delete from ";
    private static final String UNKNOWN = "unknown";
    private static final String SELECT_P = "select P.* ";
    private static final String FROM = "from ";
    private static final String FATHER_F = "father F ";
    private static final String WHERE_F_CONTACT_ID_EQUAL_TO_P_CONTACT_ID = "where F.contactId = P.contactId ";
    private static final String AND_P_INSTANCE_ID_EQUAL_TO_GIVEN_VALUE = " and P.instanceId = ? ";

    public void addFather(Connection con, ContactPK contactPK, NodePK fatherPK) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement("INSERT INTO  sb_contact_contactfather VALUES (?, ?)");){
            prepStmt.setInt(1, Integer.parseInt(contactPK.getId()));
            prepStmt.setInt(2, Integer.parseInt(fatherPK.getId()));
            prepStmt.executeUpdate();
        }
    }

    void removeFather(Connection con, ContactPK contactPK, NodePK fatherPK) throws SQLException {
        String insertStatement = DELETE_FROM + contactPK.getTableName() + "Father where contactId = ? and nodeId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(insertStatement);){
            prepStmt.setInt(1, Integer.parseInt(contactPK.getId()));
            prepStmt.setInt(2, Integer.parseInt(fatherPK.getId()));
            prepStmt.executeUpdate();
        }
    }

    void removeAllFather(Connection con, ContactPK contactPK) throws SQLException {
        String insertStatement = DELETE_FROM + contactPK.getTableName() + "Father where contactId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(insertStatement);){
            prepStmt.setInt(1, Integer.parseInt(contactPK.getId()));
            prepStmt.executeUpdate();
        }
    }

    void removeAllIssue(Connection con, NodePK originPK, ContactPK contactPK) throws SQLException {
        Object path = null;
        String selectStatement = "select nodePath from " + originPK.getTableName() + " where nodeId = ? and instanceId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setInt(1, Integer.parseInt(originPK.getId()));
            prepStmt.setString(2, originPK.getComponentName());
            try (ResultSet rs = prepStmt.executeQuery();){
                if (rs.next()) {
                    path = rs.getString(1);
                }
            }
        }
        path = (String)path + "%";
        String removeStatement = "DELETE FROM " + contactPK.getTableName() + "Father WHERE nodeId IN (SELECT nodeId FROM " + originPK.getTableName() + " WHERE nodePath like '" + (String)path + "' and instanceId = ? and nodeId= ?)";
        try (PreparedStatement prepStmt = con.prepareStatement(removeStatement);){
            prepStmt.setString(1, originPK.getComponentName());
            prepStmt.setInt(2, Integer.parseInt(originPK.getId()));
            prepStmt.executeUpdate();
        }
    }

    Collection<NodePK> getAllFatherPK(Connection con, ContactPK contactPK) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement("SELECT nodeId FROM sb_contact_contactfather WHERE contactId = ?");){
            ArrayList<NodePK> arrayList;
            block13: {
                prepStmt.setInt(1, Integer.parseInt(contactPK.getId()));
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<NodePK> list = new ArrayList<NodePK>();
                    while (rs.next()) {
                        NodePK nodePK = new NodePK(String.valueOf(rs.getInt(1)), (ResourceReference)contactPK);
                        list.add(nodePK);
                    }
                    arrayList = list;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    int getNbPubInFatherPKs(Connection con, Collection<NodePK> fatherPKs) throws SQLException {
        int result = 0;
        if (fatherPKs.isEmpty()) {
            return 0;
        }
        Iterator<NodePK> iterator = fatherPKs.iterator();
        if (iterator.hasNext()) {
            NodePK nodePK = iterator.next();
            ContactPK pubPK = new ContactPK(UNKNOWN, (ResourceReference)nodePK);
            String nodeId = nodePK.getId();
            StringBuilder selectStatement = new StringBuilder("select count(contactId) from ").append(pubPK.getTableName()).append("Father").append(" where nodeId = ").append(nodeId);
            while (iterator.hasNext()) {
                nodePK = iterator.next();
                nodeId = nodePK.getId();
                selectStatement.append(" or nodeId = ").append(nodeId);
            }
            selectStatement.append(" )");
            try (PreparedStatement prepStmt = con.prepareStatement(selectStatement.toString());
                 ResultSet rs = prepStmt.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }

    int getNbPubByFatherPath(Connection con, NodePK fatherPK, String fatherPath) throws SQLException {
        int result = 0;
        ContactPK pubPK = new ContactPK(UNKNOWN, (ResourceReference)fatherPK);
        if (fatherPath.length() <= 0) {
            return 0;
        }
        String selectStatement = "select count(F.contactId) from " + pubPK.getTableName() + "Father F, " + fatherPK.getTableName() + " N  where F.nodeId = N.nodeId  and N.instanceId = ? and N.nodeId = ? and N.nodePath like '" + fatherPath + "%'";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setString(1, fatherPK.getComponentName());
            prepStmt.setInt(2, Integer.parseInt(fatherPK.getId()));
            try (ResultSet rs = prepStmt.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }

    public void insertRow(Connection con, Contact detail) throws SQLException {
        String insertStatement = "INSERT INTO " + detail.getPK().getTableName() + " VALUES ( ? , ? , ? , ? , ? , ? , ? , ?, ? , ?)";
        try (PreparedStatement prepStmt = con.prepareStatement(insertStatement);){
            int id = Integer.parseInt(detail.getPK().getId());
            prepStmt.setInt(1, id);
            prepStmt.setString(2, detail.getFirstName());
            prepStmt.setString(3, detail.getLastName());
            prepStmt.setString(4, detail.getEmail());
            prepStmt.setString(5, detail.getPhone());
            prepStmt.setString(6, detail.getFax());
            prepStmt.setString(7, detail.getUserId());
            prepStmt.setString(8, DateUtil.today2SQLDate());
            prepStmt.setString(9, detail.getCreatorId());
            prepStmt.setString(10, detail.getPK().getComponentName());
            prepStmt.executeUpdate();
        }
    }

    void deleteContact(Connection con, ContactPK pk) throws SQLException {
        this.removeAllFather(con, pk);
        String deleteStatement = DELETE_FROM + pk.getTableName() + " where contactId = ? and instanceId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(deleteStatement);){
            prepStmt.setInt(1, Integer.parseInt(pk.getId()));
            prepStmt.setString(2, pk.getComponentName());
            prepStmt.executeUpdate();
        }
    }

    void deleteAllContacts(Connection con, String instanceId) throws SQLException {
        String allFatherDeletion = "DELETE FROM SB_Contact_ContactFather WHERE contactId in (SELECT contactId FROM SB_Contact_Contact WHERE instanceId = ?)";
        String allContactsDeletion = "DELETE FROM SB_Contact_Contact WHERE instanceId = ?";
        try (PreparedStatement deletion = con.prepareStatement("DELETE FROM SB_Contact_ContactFather WHERE contactId in (SELECT contactId FROM SB_Contact_Contact WHERE instanceId = ?)");){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
        deletion = con.prepareStatement("DELETE FROM SB_Contact_Contact WHERE instanceId = ?");
        try {
            deletion.setString(1, instanceId);
            deletion.execute();
        }
        finally {
            if (deletion != null) {
                deletion.close();
            }
        }
    }

    ContactPK selectByPrimaryKey(Connection con, ContactPK primaryKey) throws SQLException, ParseException {
        ContactDetail detail = this.loadRow(con, primaryKey);
        ContactPK primary = new ContactPK(primaryKey.getId(), primaryKey);
        primary.setContactDetail(detail);
        return primary;
    }

    private static ContactDetail resultSet2ContactDetail(ResultSet rs, ContactPK contactPK) throws SQLException, ParseException {
        int id = rs.getInt(1);
        ContactPK pk = new ContactPK(String.valueOf(id), contactPK);
        String firstName = rs.getString(2);
        String lastName = rs.getString(3);
        String email = rs.getString(4);
        String phone = rs.getString(5);
        String fax = rs.getString(6);
        String userId = rs.getString(7);
        Date creationDate = DateUtil.parse((String)rs.getString(8));
        String creatorId = rs.getString(9);
        return new ContactDetail(pk, firstName, lastName, email, phone, fax, userId, creationDate, creatorId);
    }

    Collection<ContactDetail> selectByLastName(Connection con, ContactPK pk, String query) throws SQLException, ParseException {
        String selectStatement = "select P.* from " + pk.getTableName() + " P, " + pk.getTableName() + "father F where F.contactId = P.contactId  and LOWER(P.contactLastName) LIKE LOWER(?) and P.instanceId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setString(1, query);
            prepStmt.setString(2, pk.getComponentName());
            Collection<ContactDetail> collection = this.fetchContactDetails(pk, prepStmt);
            return collection;
        }
    }

    Collection<ContactDetail> selectByLastNameOrFirstName(Connection con, ContactPK pk, String query) throws SQLException, ParseException {
        String selectStatement = "select P.* from " + pk.getTableName() + " P, " + pk.getTableName() + "father F where F.contactId = P.contactId  and (LOWER(P.contactLastName) LIKE LOWER(?) or LOWER(P.contactFirstName) LIKE LOWER(?)) and P.instanceId = ? ";
        return this.fetchContactDetails(con, selectStatement, pk, query, query);
    }

    Collection<ContactDetail> selectByFatherPK(Connection con, NodePK fatherPK) throws SQLException, ParseException {
        ContactPK pubPK = new ContactPK(UNKNOWN, (ResourceReference)fatherPK);
        String selectStatement = "select  P.* from " + pubPK.getTableName() + " P, " + pubPK.getTableName() + "father F where F.nodeId = ? and  F.contactId = P.contactId  and P.instanceId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setInt(1, Integer.parseInt(fatherPK.getId()));
            prepStmt.setString(2, fatherPK.getComponentName());
            Collection<ContactDetail> collection = this.fetchContactDetails(pubPK, prepStmt);
            return collection;
        }
    }

    private Collection<ContactDetail> fetchContactDetails(ContactPK pubPK, PreparedStatement prepStmt) throws SQLException, ParseException {
        try (ResultSet rs = prepStmt.executeQuery();){
            ArrayList<ContactDetail> list = new ArrayList<ContactDetail>();
            while (rs.next()) {
                ContactDetail pub = ContactDAO.resultSet2ContactDetail(rs, pubPK);
                list.add(pub);
            }
            ArrayList<ContactDetail> arrayList = list;
            return arrayList;
        }
    }

    Collection<ContactFatherDetail> selectByFatherPKs(Connection con, Collection<NodePK> fatherPKs, ContactPK contactPK, NodePK nodePK) throws SQLException, ParseException {
        StringBuilder whereClause = new StringBuilder();
        if (fatherPKs != null) {
            Iterator<NodePK> it = fatherPKs.iterator();
            whereClause.append("(");
            while (it.hasNext()) {
                String fatherId = it.next().getId();
                whereClause.append(" F.nodeId = ").append(fatherId);
                if (it.hasNext()) {
                    whereClause.append(" OR ");
                    continue;
                }
                whereClause.append(" ) ");
            }
        }
        String selectStatement = "select  P.*, N.nodeId, N.nodeName from " + contactPK.getTableName() + " P, " + contactPK.getTableName() + "father F, " + nodePK.getTableName() + " N where " + whereClause.toString() + " AND F.contactId = P.contactId AND F.nodeId = N.nodeId AND N.instanceId = ? AND N.instanceId = P.instanceId ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            ArrayList<ContactFatherDetail> arrayList;
            block16: {
                prepStmt.setString(1, nodePK.getComponentName());
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<ContactFatherDetail> list = new ArrayList<ContactFatherDetail>();
                    while (rs.next()) {
                        ContactDetail pub = ContactDAO.resultSet2ContactDetail(rs, contactPK);
                        ContactFatherDetail contactFather = new ContactFatherDetail(pub, rs.getString(11), rs.getString(12));
                        list.add(contactFather);
                    }
                    arrayList = list;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    Collection<ContactDetail> selectByContactPKs(Connection con, Collection<ContactPK> contactPKs) throws SQLException, ParseException {
        ArrayList<ContactDetail> contacts = new ArrayList<ContactDetail>();
        for (ContactPK contactPK : contactPKs) {
            ContactDetail contactDetail = this.loadRow(con, contactPK);
            contacts.add(contactDetail);
        }
        return contacts;
    }

    Collection<ContactDetail> getOrphanContacts(Connection con, ContactPK contactPK) throws SQLException, ParseException {
        try (PreparedStatement prepStmt = con.prepareStatement("SELECT * FROM SB_Contact_Contact WHERE contactId NOT IN (SELECT contactId FROM SB_Contact_Contactfather) AND instanceId = ? ");){
            prepStmt.setString(1, contactPK.getComponentName());
            Collection<ContactDetail> collection = this.fetchContactDetails(contactPK, prepStmt);
            return collection;
        }
    }

    void deleteOrphanContactsByCreatorId(Connection con, ContactPK contactPK, String creatorId) throws SQLException {
        String deleteStatement = DELETE_FROM + contactPK.getTableName() + " where contactCreatorId = ?  and instanceId = ?  and contactId NOT IN (Select contactId from " + contactPK.getTableName() + "father) ";
        try (PreparedStatement prepStmt = con.prepareStatement(deleteStatement);){
            prepStmt.setString(1, creatorId);
            prepStmt.setString(2, contactPK.getComponentName());
            prepStmt.executeUpdate();
        }
    }

    ContactDetail loadRow(Connection con, ContactPK pk) throws SQLException, ParseException {
        String selectStatement = "select  * from " + pk.getTableName() + " where contactId = ? and instanceId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setInt(1, Integer.parseInt(pk.getId()));
            prepStmt.setString(2, pk.getComponentName());
            try (ResultSet rs = prepStmt.executeQuery();){
                if (rs.next()) {
                    ContactDetail contactDetail = ContactDAO.resultSet2ContactDetail(rs, pk);
                    return contactDetail;
                }
                throw new ContactRuntimeException("Contact not found with id = " + pk.getId());
            }
        }
    }

    void storeRow(Connection con, Contact detail) throws SQLException {
        String insertStatement = "update " + detail.getPK().getTableName() + " set contactFirstName = ? , contactLastName = ? , contactEmail = ? , contactPhone = ? , contactFax = ? , userId = ? ,contactCreationDate = ? , contactCreatorId = ? where contactId = ? and instanceId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(insertStatement);){
            prepStmt.setString(1, detail.getFirstName());
            prepStmt.setString(2, detail.getLastName());
            prepStmt.setString(3, detail.getEmail());
            prepStmt.setString(4, detail.getPhone());
            prepStmt.setString(5, detail.getFax());
            prepStmt.setString(6, detail.getUserId());
            prepStmt.setString(7, DateUtil.date2SQLDate((Date)detail.getCreationDate()));
            prepStmt.setString(8, detail.getCreatorId());
            prepStmt.setInt(9, Integer.parseInt(detail.getPK().getId()));
            prepStmt.setString(10, detail.getPK().getComponentName());
            int rowCount = prepStmt.executeUpdate();
            if (rowCount == 0) {
                throw new ContactRuntimeException("Contact update failure. Id = " + detail.getPK().getId());
            }
        }
    }

    Collection<ContactDetail> getUnavailableContactsByPublisherId(Connection con, ContactPK contactPK, String publisherId, String nodeId) throws SQLException, ParseException {
        String selectStatement = "SELECT  P.* FROM " + contactPK.getTableName() + " P, " + contactPK.getTableName() + "father F WHERE F.nodeId = ? AND contactCreatorId = ? AND F.contactId = P.contactId AND P.instanceId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setInt(1, Integer.parseInt(nodeId));
            prepStmt.setString(2, publisherId);
            prepStmt.setString(3, contactPK.getComponentName());
            Collection<ContactDetail> collection = this.fetchContactDetails(contactPK, prepStmt);
            return collection;
        }
    }

    Collection<ContactDetail> selectByLastNameAndFirstName(Connection con, ContactPK pk, String lastName, String firstName) throws SQLException, ParseException {
        String selectStatement = "select P.* from " + pk.getTableName() + " P, " + pk.getTableName() + "father F where F.contactId = P.contactId  and LOWER(P.contactLastName) LIKE LOWER(?) and LOWER(P.contactFirstName) LIKE LOWER(?) and P.instanceId = ? ";
        return this.fetchContactDetails(con, selectStatement, pk, lastName, firstName);
    }

    private Collection<ContactDetail> fetchContactDetails(Connection con, String selectStatement, ContactPK pk, String lastName, String firstName) throws SQLException, ParseException {
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setString(1, lastName);
            prepStmt.setString(2, firstName);
            prepStmt.setString(3, pk.getComponentName());
            Collection<ContactDetail> collection = this.fetchContactDetails(pk, prepStmt);
            return collection;
        }
    }

    List<CompleteContact> getVisibleContacts(Connection con, String instanceId) throws SQLException, ParseException {
        ContactPK pubPK = new ContactPK(UNKNOWN, instanceId);
        String selectStatement = "select P.*, I.modelId from " + pubPK.getTableName() + " P join " + pubPK.getTableName() + "father F on F.contactId = P.contactId left outer join sb_contact_info I on P.contactId = I.contactId where F.nodeId <> ? and P.instanceId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            ArrayList<CompleteContact> arrayList;
            block13: {
                prepStmt.setInt(1, Integer.parseInt("1"));
                prepStmt.setString(2, instanceId);
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<CompleteContact> list = new ArrayList<CompleteContact>();
                    while (rs.next()) {
                        ContactDetail pub = ContactDAO.resultSet2ContactDetail(rs, pubPK);
                        CompleteContact contact = new CompleteContact(pub, rs.getString("modelId"));
                        list.add(contact);
                    }
                    arrayList = list;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }
}

