/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.attribute;

import edu.psu.swe.scim.spec.validator.Urn;
import java.io.Serializable;

public class AttributeReference
implements Serializable {
    private static final long serialVersionUID = -3559538009692681470L;
    @Urn
    String urn;
    String attributeName;
    String subAttributeName;

    public AttributeReference(String name) {
        int endOfUrn = name.lastIndexOf(58);
        String[] attributes = name.substring(endOfUrn + 1).split("\\.");
        this.attributeName = attributes[0];
        if (endOfUrn > -1) {
            this.urn = name.substring(0, endOfUrn);
        }
        if (attributes.length > 1) {
            this.subAttributeName = attributes[1];
        }
    }

    public AttributeReference(String urn, String name) {
        this.urn = urn;
        if (name != null) {
            String[] attributes = name.split("\\.");
            this.attributeName = attributes[0];
            if (attributes.length > 1) {
                this.subAttributeName = attributes[1];
            }
        }
    }

    public AttributeReference(String urn, String attributeName, String subAttributeName) {
        this.urn = urn;
        this.attributeName = attributeName;
        this.subAttributeName = subAttributeName;
    }

    public String getFullAttributeName() {
        return this.attributeName + (this.subAttributeName != null ? "." + this.subAttributeName : "");
    }

    public String getFullyQualifiedAttributeName() {
        StringBuilder sb = new StringBuilder();
        if (this.urn != null) {
            sb.append(this.urn);
            if (this.attributeName != null) {
                sb.append(":");
            }
        }
        if (this.attributeName != null) {
            sb.append(this.attributeName);
        }
        if (this.subAttributeName != null) {
            sb.append(".");
            sb.append(this.subAttributeName);
        }
        String fullyQualifiedAttributeName = sb.toString();
        return fullyQualifiedAttributeName;
    }

    public String getAttributeBase() {
        StringBuilder sb = new StringBuilder();
        if (this.urn != null) {
            sb.append(this.urn);
            if (this.subAttributeName != null) {
                sb.append(":");
                sb.append(this.attributeName);
            }
        } else if (this.subAttributeName != null) {
            sb.append(this.attributeName);
        }
        String attributeBase = sb.toString();
        return attributeBase;
    }

    public String toString() {
        return (this.urn != null ? this.urn + ":" : "") + this.attributeName + (this.subAttributeName != null ? "." + this.subAttributeName : "");
    }

    public String getUrn() {
        return this.urn;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getSubAttributeName() {
        return this.subAttributeName;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setSubAttributeName(String subAttributeName) {
        this.subAttributeName = subAttributeName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeReference)) {
            return false;
        }
        AttributeReference other = (AttributeReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$urn = this.getUrn();
        String other$urn = other.getUrn();
        if (this$urn == null ? other$urn != null : !this$urn.equals(other$urn)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$subAttributeName = this.getSubAttributeName();
        String other$subAttributeName = other.getSubAttributeName();
        return !(this$subAttributeName == null ? other$subAttributeName != null : !this$subAttributeName.equals(other$subAttributeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $urn = this.getUrn();
        result = result * 59 + ($urn == null ? 43 : $urn.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $subAttributeName = this.getSubAttributeName();
        result = result * 59 + ($subAttributeName == null ? 43 : $subAttributeName.hashCode());
        return result;
    }
}

