/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.container.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.clipboard.SKDException;
import org.silverpeas.core.clipboard.SilverpeasKeyData;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerDetail;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerPK;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class QuestionContainerSelection
extends ClipboardSelection
implements Serializable {
    private static final long serialVersionUID = 1311812797166397833L;
    private static final String TYPE = "QuestionContainer";
    public static final DataFlavor QuestionContainerDetailFlavor = new DataFlavor(QuestionContainerDetail.class, "QuestionContainer");
    private final QuestionContainerDetail questionContainer;

    public QuestionContainerSelection(QuestionContainerDetail questionContainer) {
        this.questionContainer = questionContainer;
        super.addFlavor(QuestionContainerDetailFlavor);
    }

    @Nonnull
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException {
        Object transferedData;
        try {
            transferedData = super.getTransferData(parFlavor);
        }
        catch (UnsupportedFlavorException e) {
            if (parFlavor.equals(QuestionContainerDetailFlavor)) {
                transferedData = this.questionContainer;
            }
            throw e;
        }
        return transferedData;
    }

    public IndexEntry getIndexEntry() {
        QuestionContainerPK questionContainerPK = this.questionContainer.getHeader().getPK();
        IndexEntry indexEntry = new IndexEntry(new IndexEntryKey(questionContainerPK.getComponentName(), TYPE, questionContainerPK.getId()));
        indexEntry.setTitle(this.questionContainer.getHeader().getName());
        return indexEntry;
    }

    public SilverpeasKeyData getKeyData() {
        SilverpeasKeyData keyData = new SilverpeasKeyData(this.questionContainer.getId(), this.questionContainer.getComponentInstanceId());
        keyData.setTitle(this.questionContainer.getHeader().getName());
        keyData.setAuthor(this.questionContainer.getHeader().getCreatorId());
        keyData.setCreationDate(this.questionContainer.getHeader().getCreationDate());
        keyData.setDesc(this.questionContainer.getHeader().getDescription());
        keyData.setType(TYPE);
        if (this.questionContainer.getComponentInstanceId().startsWith("survey")) {
            keyData.setLink(URLUtil.getSimpleURL((int)5, (String)this.questionContainer.getId(), (String)this.questionContainer.getComponentInstanceId()));
        } else {
            keyData.setLink(URLUtil.getSimpleURL((int)1, (String)this.questionContainer.getComponentInstanceId()));
        }
        try {
            if (this.questionContainer.getHeader().getBeginDate() != null) {
                keyData.setProperty("BEGINDATE", this.questionContainer.getHeader().getBeginDate());
            }
            if (this.questionContainer.getHeader().getEndDate() != null) {
                keyData.setProperty("ENDDATE", this.questionContainer.getHeader().getEndDate());
            }
        }
        catch (SKDException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
        return keyData;
    }
}

