/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.container.model;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentInterface;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.i18n.AbstractBean;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerPK;
import org.silverpeas.core.questioncontainer.score.model.ScoreDetail;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class QuestionContainerHeader
extends AbstractBean
implements Serializable,
SilverContentInterface,
WithPermanentLink {
    private static final long serialVersionUID = 6871118433726400355L;
    private QuestionContainerPK pk = null;
    private String comment = null;
    private String creatorId = null;
    private String creationDate = null;
    private String beginDate = null;
    private String endDate = null;
    private boolean isClosed = false;
    private int nbVoters = 0;
    private int nbQuestionsPerPage = 0;
    private int nbMaxParticipations = 0;
    private int nbParticipationsBeforeSolution = 0;
    private int maxTime = 0;
    private int nbMaxPoints = 0;
    private Collection<ScoreDetail> scores = null;
    private boolean anonymous;
    private String iconUrl;
    private int resultMode;
    public static final int IMMEDIATE_RESULTS = 1;
    public static final int DELAYED_RESULTS = 2;
    private int resultView;
    public static final int NOTHING_DISPLAY_RESULTS = 1;
    public static final int CLASSIC_DISPLAY_RESULTS = 2;
    public static final int DETAILED_DISPLAY_RESULTS = 3;
    public static final int TWICE_DISPLAY_RESULTS = 4;

    public QuestionContainerHeader(QuestionContainerPK questionContainerPK, String title, String description, String comment, String creatorId, String creationDate, String beginDate, String endDate, boolean isClosed, int nbVoters, int nbQuestionsPerPage, int nbMaxParticipations, int nbParticipationsBeforeSolution, int maxTime, int resultMode, int resultView) {
        this.setPK(questionContainerPK);
        this.setTitle(title);
        this.setDescription(description);
        this.setComment(comment);
        this.setCreatorId(creatorId);
        this.setCreationDate(creationDate);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.close(isClosed);
        this.setNbVoters(nbVoters);
        this.setNbQuestionsPerPage(nbQuestionsPerPage);
        this.setNbMaxParticipations(nbMaxParticipations);
        this.setNbParticipationsBeforeSolution(nbParticipationsBeforeSolution);
        this.setMaxTime(maxTime);
        this.setResultMode(resultMode);
        this.setResultView(resultView);
    }

    public QuestionContainerHeader(QuestionContainerPK questionContainerPK, String title, String description, String comment, String creatorId, String creationDate, String beginDate, String endDate, boolean isClosed, int nbVoters, int nbQuestionsPerPage, int nbMaxParticipations, int nbParticipationsBeforeSolution, int maxTime, boolean anonymous, int resultMode, int resultView) {
        this.setPK(questionContainerPK);
        this.setTitle(title);
        this.setDescription(description);
        this.setComment(comment);
        this.setCreatorId(creatorId);
        this.setCreationDate(creationDate);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.close(isClosed);
        this.setNbVoters(nbVoters);
        this.setNbQuestionsPerPage(nbQuestionsPerPage);
        this.setNbMaxParticipations(nbMaxParticipations);
        this.setNbParticipationsBeforeSolution(nbParticipationsBeforeSolution);
        this.setMaxTime(maxTime);
        this.setAnonymous(anonymous);
        this.setResultMode(resultMode);
        this.setResultView(resultView);
    }

    public QuestionContainerHeader(QuestionContainerPK questionContainerPK, String title, String description, String creatorId, String creationDate, String beginDate, String endDate, boolean isClosed, int nbVoters, int nbQuestionsPerPage, boolean anonymous, int resultMode, int resultView) {
        this.setPK(questionContainerPK);
        this.setTitle(title);
        this.setDescription(description);
        this.setComment(this.comment);
        this.setCreatorId(creatorId);
        this.setCreationDate(creationDate);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.close(isClosed);
        this.setNbVoters(nbVoters);
        this.setNbQuestionsPerPage(nbQuestionsPerPage);
        this.setAnonymous(anonymous);
        this.setResultMode(resultMode);
        this.setResultView(resultView);
    }

    public QuestionContainerPK getPK() {
        return this.pk;
    }

    public String getTitle() {
        return this.getName();
    }

    public String getComment() {
        return this.comment;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Date getCreationDate() {
        if (this.creationDate != null) {
            try {
                return DateUtil.parse((String)this.creationDate);
            }
            catch (ParseException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
                try {
                    return DateUtil.parseISO8601Date((String)this.creationDate);
                }
                catch (ParseException e2) {
                    SilverLogger.getLogger((Object)this).warn((Throwable)e2);
                }
            }
        }
        return null;
    }

    public Date getLastUpdateDate() {
        return this.getCreationDate();
    }

    public User getCreator() {
        return User.getById((String)this.getCreatorId());
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public String getBeginDate() {
        return this.beginDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public int getNbVoters() {
        return this.nbVoters;
    }

    public int getNbRegistered() {
        Optional component = SilverpeasComponentInstance.getById((String)this.getComponentInstanceId());
        if (component.isPresent()) {
            if (((SilverpeasComponentInstance)component.get()).isPublic()) {
                return OrganizationController.get().getAllUsersIds().length;
            }
            return OrganizationController.get().getAllUsers(this.getComponentInstanceId()).length;
        }
        return 0;
    }

    public int getNbQuestionsPerPage() {
        return this.nbQuestionsPerPage;
    }

    public int getNbMaxParticipations() {
        return this.nbMaxParticipations;
    }

    public int getNbParticipationsBeforeSolution() {
        return this.nbParticipationsBeforeSolution;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public int getNbMaxPoints() {
        return this.nbMaxPoints;
    }

    public Collection<ScoreDetail> getScores() {
        return this.scores;
    }

    public void setPK(QuestionContainerPK pk) {
        this.pk = pk;
    }

    public void setTitle(String title) {
        this.setName(title);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void close(boolean isClosed) {
        this.isClosed = isClosed;
    }

    public void setNbVoters(int nb) {
        this.nbVoters = nb;
    }

    public void setNbQuestionsPerPage(int nb) {
        this.nbQuestionsPerPage = nb;
    }

    public void setNbMaxParticipations(int nb) {
        this.nbMaxParticipations = nb;
    }

    public void setNbParticipationsBeforeSolution(int nb) {
        this.nbParticipationsBeforeSolution = nb;
    }

    public void setMaxTime(int nb) {
        this.maxTime = nb;
    }

    public void setNbMaxPoints(int nb) {
        this.nbMaxPoints = nb;
    }

    public void setScores(Collection<ScoreDetail> scores) {
        this.scores = scores;
    }

    public String getURL() {
        return "searchResult?Type=QuestionContainer&Id=" + this.getId();
    }

    public String getId() {
        return this.getPK().getId();
    }

    public String getInstanceId() {
        return this.getPK().getComponentName();
    }

    public String getDate() {
        return this.creationDate;
    }

    public String getSilverCreationDate() {
        return this.getDate();
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getPermalink() {
        if (URLUtil.displayUniversalLinks()) {
            return URLUtil.getSimpleURL((int)5, (String)this.getId(), (String)this.getInstanceId());
        }
        return null;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public int getResultMode() {
        return this.resultMode;
    }

    public void setResultMode(int resultMode) {
        this.resultMode = resultMode;
    }

    public int getResultView() {
        return this.resultView;
    }

    public void setResultView(int resultView) {
        this.resultView = resultView;
    }
}

