/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.silvercrawler.statistic;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.silverpeas.components.silvercrawler.statistic.HistoryDetail;

public class HistoryDAO {
    public static Collection<HistoryDetail> getHistoryDetails(ResultSet rs) throws SQLException {
        ArrayList<HistoryDetail> list = new ArrayList<HistoryDetail>();
        while (rs.next()) {
            Date date = new Date(Long.parseLong(rs.getString(1)));
            String userId = rs.getString(2);
            String path = rs.getString(3);
            HistoryDetail detail = new HistoryDetail(date, userId, path);
            list.add(detail);
        }
        return list;
    }

    public static void add(Connection con, String tableName, String userId, String path, String componentId, String objectType) throws SQLException {
        String insertStatement = "insert into " + tableName + " values (?, ?, ?, ?, ?)";
        Date date = new Date();
        try (PreparedStatement prepStmt = con.prepareStatement(insertStatement);){
            prepStmt.setString(1, Long.toString(date.getTime()));
            prepStmt.setString(2, userId);
            prepStmt.setString(3, path);
            prepStmt.setString(4, componentId);
            prepStmt.setString(5, objectType);
            prepStmt.executeUpdate();
        }
    }

    public static Collection<HistoryDetail> getHistoryDetailByObject(Connection con, String tableName, String path, String componentId) throws SQLException {
        String selectStatement = "select * from " + tableName + " where path = ? and componentId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            Collection<HistoryDetail> collection;
            block12: {
                prepStmt.setString(1, path);
                prepStmt.setString(2, componentId);
                ResultSet rs = prepStmt.executeQuery();
                try {
                    Collection<HistoryDetail> list;
                    collection = list = HistoryDAO.getHistoryDetails(rs);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return collection;
        }
    }

    public static Collection<HistoryDetail> getHistoryDetailByObjectAndUser(Connection con, String tableName, String path, String userId, String componentId) throws SQLException {
        String selectStatement = "select * from " + tableName + " where path = ? and componentId = ? and userId = ?  order by dateDownload desc";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            Collection<HistoryDetail> collection;
            block12: {
                prepStmt.setString(1, path);
                prepStmt.setString(2, componentId);
                prepStmt.setString(3, userId);
                ResultSet rs = prepStmt.executeQuery();
                try {
                    Collection<HistoryDetail> list;
                    collection = list = HistoryDAO.getHistoryDetails(rs);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return collection;
        }
    }

    public static void deleteHistoryByObject(Connection con, String tableName, String path, String componentId) throws SQLException {
        String query = "delete from " + tableName + " where path = ? and componentId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, path);
            prepStmt.setString(2, componentId);
            prepStmt.executeUpdate();
        }
    }
}

