/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Length;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;

public class LburpOperationResponse
extends LDAPExtendedResponse {
    private HashMap response = new HashMap(5);

    public LburpOperationResponse(RfcLDAPMessage rfcMessage) throws IOException {
        super(rfcMessage);
        byte[] returnedValue = this.getValue();
        if (returnedValue == null) {
            throw new IOException("No returned value");
        }
        ASN1Identifier asn1ID = new ASN1Identifier();
        ASN1Length asn1Len = new ASN1Length();
        LBERDecoder dec = new LBERDecoder();
        Object asn1 = null;
        ByteArrayInputStream in = new ByteArrayInputStream(returnedValue);
        try {
            int[] len = new int[1];
            while (true) {
                int length;
                asn1ID.reset(in);
                asn1Len.reset(in);
                len[0] = asn1ID.getEncodedLength() + asn1Len.getEncodedLength() + length;
                int TAG = 16;
                ASN1Identifier ID = new ASN1Identifier(0, true, TAG);
                int contentIndex = 0;
                ASN1Object[] content = new ASN1Object[10];
                int[] componentLen = new int[1];
                for (length = asn1Len.getLength(); length > 0; length -= componentLen[0]) {
                    content[contentIndex++] = dec.decode(in, componentLen);
                }
                ASN1Object obj = content[0];
                int record = ((ASN1Integer)obj).intValue();
                ASN1Tagged tval = (ASN1Tagged)content[1];
                ASN1OctetString astr = (ASN1OctetString)tval.taggedValue();
                byte[] bval = astr.byteValue();
                ByteArrayInputStream ins = new ByteArrayInputStream(bval);
                int[] compLen = new int[1];
                ASN1Object asb = dec.decode(ins, compLen);
                asn1ID.reset(ins);
                asn1Len.reset(ins);
                ASN1Object asn2 = dec.decode(ins, len);
                String resp = ((ASN1OctetString)asn2).stringValue();
                if (resp.length() == 0) continue;
                this.response.put(new Integer(record), new String(resp));
            }
        }
        catch (IOException ioe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap getResponse() {
        return this.response;
    }
}

