/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.client.Debug;
import com.novell.ldap.events.LDAPEvent;
import com.novell.ldap.events.LDAPEventListener;
import com.novell.ldap.events.LDAPExceptionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class LDAPEventSource {
    private long sleepTime = 1000L;
    private Map listenermap = new TreeMap(new HashComparator());

    protected void stopeventpolling(LDAPEventListener alistener) throws LDAPException {
        if (alistener == null) {
            throw new IllegalArgumentException("No parameter can be Null.");
        }
        if (!this.listenermap.containsKey(alistener)) {
            Debug.trace("EventsTrace", "Unknown Listener send for removal");
            throw new LDAPException(null, 80, "This in not a registered Listener");
        }
        Iterator eventthreaditerator = ((List)this.listenermap.get(alistener)).iterator();
        this.listenermap.remove(alistener);
        while (eventthreaditerator.hasNext()) {
            EventsGenerator generator = (EventsGenerator)eventthreaditerator.next();
            generator.stopEventGeneration();
        }
    }

    protected void pollforevents(LDAPMessageQueue queue, LDAPConnection conn, LDAPEventListener alistener, int msgid, LDAPEventSource source) {
        if (queue == null || conn == null || alistener == null || source == null) {
            throw new IllegalArgumentException("No parameter can be Null.");
        }
        EventsGenerator eventsthread = this.createListeningThread(queue, conn, alistener, msgid, source);
        eventsthread.start();
        List<EventsGenerator> eventdecoratorlist = null;
        if (this.listenermap.containsKey(alistener)) {
            eventdecoratorlist = (List)this.listenermap.get(alistener);
        } else {
            eventdecoratorlist = new ArrayList();
            this.listenermap.put(alistener, eventdecoratorlist);
        }
        eventdecoratorlist.add(eventsthread);
    }

    protected EventsGenerator createListeningThread(LDAPMessageQueue queue, LDAPConnection conn, LDAPEventListener alistener, int msgid, LDAPEventSource source) {
        return new EventsGenerator(source, queue, alistener, conn, msgid);
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Sleep Time must be a non-zero positive number");
        }
        this.sleepTime = l;
    }

    private class HashComparator
    implements Comparator {
        private HashComparator() {
        }

        public int compare(Object o1, Object o2) {
            int hash2;
            int hash1 = o1.hashCode();
            if (hash1 > (hash2 = o2.hashCode())) {
                return 1;
            }
            if (hash1 < hash2) {
                return -1;
            }
            return 0;
        }
    }

    protected class EventsGenerator
    extends Thread {
        private final LDAPMessageQueue searchqueue;
        private final LDAPEventSource eventsource;
        private final int messageid;
        private final LDAPConnection ldapconnection;
        private final LDAPEventListener eventlistener;
        private volatile boolean isrunning = true;

        public EventsGenerator(LDAPEventSource aeventsource, LDAPMessageQueue queue, LDAPEventListener listener, LDAPConnection aconnection, int amessageid) {
            this.eventsource = aeventsource;
            this.searchqueue = queue;
            this.eventlistener = listener;
            this.ldapconnection = aconnection;
            this.messageid = amessageid;
        }

        public final void run() {
            while (this.isrunning) {
                try {
                    LDAPMessage response = null;
                    while (this.isrunning && !this.searchqueue.isResponseReceived(this.messageid)) {
                        try {
                            EventsGenerator.sleep(LDAPEventSource.this.sleepTime);
                        }
                        catch (InterruptedException e) {
                            Debug.trace("EventsTrace", "Interrupt Exception" + e.getMessage());
                        }
                    }
                    if (this.isrunning) {
                        response = this.searchqueue.getResponse(this.messageid);
                    }
                    if (response == null) continue;
                    this.processmessage(response);
                }
                catch (LDAPException e) {
                    LDAPExceptionEvent exceptionevent = new LDAPExceptionEvent(this.eventsource, e, null);
                    this.eventlistener.ldapExceptionNotification(exceptionevent);
                }
            }
        }

        protected void processmessage(LDAPMessage response) {
            if (response instanceof LDAPResponse) {
                try {
                    ((LDAPResponse)response).chkResultCode();
                    this.eventlistener.ldapEventNotification(new LDAPEvent(this.eventsource, response, -1, -1));
                }
                catch (LDAPException e) {
                    LDAPExceptionEvent exceptionevent = new LDAPExceptionEvent(this.eventsource, e, response);
                    this.eventlistener.ldapExceptionNotification(exceptionevent);
                }
            } else {
                this.eventlistener.ldapEventNotification(new LDAPEvent(this.eventsource, response, -1, -1));
            }
        }

        public final void stopEventGeneration() throws LDAPException {
            Debug.trace("EventsTrace", "Closing EventGeneration");
            this.isrunning = false;
            this.ldapconnection.abandon(this.searchqueue);
        }
    }
}

