/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.client.Debug;
import com.novell.ldap.client.ReferralInfo;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPSearchResults
implements Externalizable {
    private Vector entries;
    private int entryCount;
    private int entryIndex;
    private Vector references;
    private int referenceCount;
    private int referenceIndex;
    private int batchSize;
    private boolean completed = false;
    private LDAPControl[] controls = null;
    private LDAPSearchQueue queue;
    private static Object nameLock = new Object();
    private static int resultsNum = 0;
    private String name;
    private LDAPConnection conn;
    private LDAPSearchConstraints cons;
    private ArrayList referralConn = null;

    public LDAPSearchResults() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LDAPSearchResults(LDAPConnection conn, LDAPSearchQueue queue, LDAPSearchConstraints cons) {
        this.conn = conn;
        this.cons = cons;
        int batchSize = cons.getBatchSize();
        int vectorIncr = batchSize == 0 ? 64 : 0;
        this.entries = new Vector(batchSize == 0 ? 64 : batchSize, vectorIncr);
        this.entryCount = 0;
        this.entryIndex = 0;
        this.references = new Vector(5, 5);
        this.referenceCount = 0;
        this.referenceIndex = 0;
        this.queue = queue;
        this.batchSize = batchSize == 0 ? Integer.MAX_VALUE : batchSize;
        Object object = nameLock;
        synchronized (object) {
            this.name = "LDAPSearchResults(" + ++resultsNum + "): ";
        }
        Debug.trace("Messages", this.name + " Object created, batch size " + this.batchSize + ", hops " + cons.getHopLimit());
    }

    public int getCount() {
        int qCount = this.queue.getMessageAgent().getCount();
        return this.entryCount - this.entryIndex + this.referenceCount - this.referenceIndex + qCount;
    }

    public LDAPControl[] getResponseControls() {
        return this.controls;
    }

    public boolean hasMore() {
        boolean ret = false;
        if (this.entryIndex < this.entryCount || this.referenceIndex < this.referenceCount) {
            ret = true;
        } else if (!this.completed) {
            this.resetVectors();
            ret = this.entryIndex < this.entryCount || this.referenceIndex < this.referenceCount;
        }
        Debug.trace("Messages", this.name + "hasMoreElements: returns " + ret + ", enumeration status " + ", entryIdx=" + this.entryIndex + ", entryCnt=" + this.entryCount + ", referIdx=" + this.referenceIndex + ", referCnt=" + this.referenceCount);
        return ret;
    }

    private void resetVectors() {
        if (this.completed) {
            return;
        }
        if (this.referenceIndex != 0 && this.referenceIndex >= this.referenceCount) {
            this.references.setSize(0);
            this.referenceCount = 0;
            this.referenceIndex = 0;
        }
        if (this.entryIndex != 0 && this.entryIndex >= this.entryCount) {
            this.entries.setSize(0);
            this.entryCount = 0;
            this.entryIndex = 0;
        }
        if (this.referenceIndex == 0 && this.referenceCount == 0 && this.entryIndex == 0 && this.entryCount == 0) {
            this.completed = this.getBatchOfResults();
        }
    }

    public LDAPEntry next() throws LDAPException {
        if (this.completed && this.entryIndex >= this.entryCount && this.referenceIndex >= this.referenceCount) {
            throw new NoSuchElementException("LDAPSearchResults.next() no more results");
        }
        this.resetVectors();
        Object element = null;
        if (this.referenceIndex < this.referenceCount) {
            String[] refs = (String[])this.references.elementAt(this.referenceIndex++);
            Debug.trace("Messages", this.name + "next: throws referral exception");
            for (int i = 0; i < refs.length; ++i) {
                Debug.trace("Messages", this.name + " \t" + refs[i]);
            }
            LDAPReferralException rex = new LDAPReferralException("REFERENCE_NOFOLLOW");
            rex.setReferrals(refs);
            throw rex;
        }
        if (this.entryIndex < this.entryCount) {
            element = this.entries.elementAt(this.entryIndex++);
            Debug.trace("Messages", this.name + "next: returns " + element.getClass().getName() + "@" + Integer.toHexString(element.hashCode()) + ", elements remaining " + this.entries.size());
            if (element instanceof LDAPResponse) {
                if (((LDAPResponse)element).hasException()) {
                    LDAPResponse lr = (LDAPResponse)element;
                    ReferralInfo ri = lr.getActiveReferral();
                    Debug.trace("Messages", this.name + "next: LDAPResponse has embedded exception" + " from following referral - " + (ri != null));
                    if (ri != null) {
                        LDAPReferralException rex = new LDAPReferralException("REFERENCE_ERROR", lr.getException());
                        rex.setReferrals(ri.getReferralList());
                        rex.setFailedReferral(ri.getReferralUrl().toString());
                        throw rex;
                    }
                }
                ((LDAPResponse)element).chkResultCode();
            } else if (element instanceof LDAPException) {
                Debug.trace("Messages", this.name + "next: LDAPException " + element.toString());
                throw (LDAPException)element;
            }
        } else {
            Debug.trace("Messages", this.name + "next: No entry found and request incomplete\n" + "\tentryIdx " + this.entryIndex + ", entryCnt " + this.entryCount + ", referIdx " + this.referenceIndex + ", referCnt " + this.referenceCount);
            throw new LDAPException("REFERRAL_LOCAL", new Object[]{"next"}, 82, (String)null);
        }
        return (LDAPEntry)element;
    }

    private boolean getBatchOfResults() {
        int i = 0;
        while (i < this.batchSize) {
            try {
                LDAPMessage msg = this.queue.getResponse();
                if (msg != null) {
                    LDAPControl[] ctls = msg.getControls();
                    if (ctls != null) {
                        Debug.trace("Controls", this.name + "Saving returned controls in " + "LDAPSearchResults local variable.");
                        this.controls = ctls;
                    }
                    if (msg instanceof LDAPSearchResult) {
                        LDAPEntry entry = ((LDAPSearchResult)msg).getEntry();
                        this.entries.addElement(entry);
                        ++i;
                        ++this.entryCount;
                        Debug.trace("Messages", this.name + "read LDAPEntry@" + Integer.toHexString(entry.hashCode()) + " from LDAPMessage@" + Integer.toHexString(msg.hashCode()));
                        continue;
                    }
                    if (msg instanceof LDAPSearchResultReference) {
                        String[] refs = ((LDAPSearchResultReference)msg).getReferrals();
                        Debug.trace("Messages", this.name + "got " + refs.length + " references in entry ");
                        for (int k = 0; k < refs.length; ++k) {
                            Debug.trace("Messages", this.name + "reference " + k + "\t" + refs[k]);
                        }
                        if (this.cons.getReferralFollowing()) {
                            this.referralConn = this.conn.chaseReferral(this.queue, this.cons, msg, refs, 0, true, this.referralConn);
                            continue;
                        }
                        this.references.addElement(refs);
                        ++this.referenceCount;
                        continue;
                    }
                    LDAPResponse resp = (LDAPResponse)msg;
                    int resultCode = resp.getResultCode();
                    if (resp.hasException()) {
                        resultCode = 91;
                        Debug.trace("Messages", this.name + "LDAPResponse with embeddedException");
                    } else {
                        Debug.trace("Messages", this.name + "read LDAPResponse@" + Integer.toHexString(resp.hashCode()) + ", result " + resultCode);
                    }
                    if (resultCode == 10 && this.cons.getReferralFollowing()) {
                        Debug.trace("Messages", this.name + "following referrals");
                        this.referralConn = this.conn.chaseReferral(this.queue, this.cons, resp, resp.getReferrals(), 0, false, this.referralConn);
                    } else if (resultCode != 0) {
                        this.entries.addElement(resp);
                        ++this.entryCount;
                        Debug.trace("Messages", this.name + "Add LDAPResponse to entry list, count = " + this.entries.size());
                    }
                    Debug.trace("Messages", this.name + "checking for done");
                    int[] msgIDs = this.queue.getMessageIDs();
                    if (msgIDs.length == 0) {
                        Debug.trace("Messages", this.name + "Search completed, all responses processed");
                        this.conn.releaseReferralConnections(this.referralConn);
                        return true;
                    }
                    Debug.trace("Messages", this.name + "Search not done, " + msgIDs.length + " Messages still active");
                    continue;
                }
                Debug.trace("Messages", this.name + "Connection timeout, no results returned");
                LDAPException e = new LDAPException(null, 85, null);
                this.entries.addElement(e);
                break;
            }
            catch (LDAPException e) {
                Debug.trace("Messages", this.name + "Caught exception, add to entry queue: " + e.toString());
                this.entries.addElement(e);
            }
        }
        return false;
    }

    void abandon() {
        Debug.trace("Messages", this.name + "abandon: Entry");
        this.queue.getMessageAgent().abandonAll();
        this.resetVectors();
        this.completed = true;
    }

    private void writeAttribute(LDAPAttribute attr, StringBuffer buff) throws IOException {
        buff.append(ValueXMLhandler.newLine(2));
        buff.append("<attr name=\"");
        buff.append(attr.getName());
        buff.append("\">");
        String[] values = attr.getStringValueArray();
        byte[][] bytevalues = attr.getByteValueArray();
        for (int i = 0; i < values.length; ++i) {
            buff.append(ValueXMLhandler.newLine(3));
            if (Base64.isValidUTF8(bytevalues[i], false)) {
                buff.append("<value><![CDATA[");
                buff.append(values[i]);
                buff.append("]]></value>");
                continue;
            }
            buff.append("<value xsi:type=\"xsd:base64Binary\"><![CDATA[");
            buff.append(Base64.encode(bytevalues[i]));
            buff.append("]]></value>");
        }
        buff.append(ValueXMLhandler.newLine(2));
        buff.append("</attr>");
    }

    private void writeControl(LDAPControl control, StringBuffer buff) throws IOException {
        buff.append("<control type=\"");
        buff.append(control.getID());
        buff.append("\" criticality=\"" + control.isCritical() + "\"");
        byte[] value = control.getValue();
        if (value == null) {
            buff.append("/>");
        } else {
            buff.append(">");
            buff.append(ValueXMLhandler.newLine(2));
            buff.append("<controlValue xsi:type=\"xsd:base64Binary\">");
            buff.append(Base64.encode(value));
            buff.append("</controlValue>");
            buff.append(ValueXMLhandler.newLine(1));
            buff.append("</control>");
        }
        buff.append(ValueXMLhandler.newLine(0));
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPSearchResults.getTopXMLHandler("LDAPSearchResults", null));
        return (Vector)xmlreader.parseXML(input);
    }

    private static LDAPXMLHandler getTopXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            Vector ldapEntries = new Vector();

            protected void initHandler() {
                this.setchildelement(LDAPSearchResults.getXMLEntryHandler("LDAPEntry", this));
                this.setchildelement(LDAPSearchResults.getXMLControlHandler("control", this));
            }

            protected void endElement() {
                this.setObject(this.ldapEntries);
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("LDAPEntry")) {
                    this.ldapEntries.add(value);
                } else if (tag.equals("control")) {
                    this.ldapEntries.add(value);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLControlHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String oid;
            boolean critical;
            byte[] controlvalue;

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler("controlValue", this));
            }

            protected void endElement() {
                LDAPControl control = new LDAPControl(this.oid, this.critical, this.controlvalue);
                this.setObject(control);
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("controlValue")) {
                    this.controlvalue = (byte[])value;
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.oid = attributes.getValue("type");
                if (this.oid == null) {
                    throw new SAXException("type is mandatory for a Control");
                }
                this.critical = "true".equalsIgnoreCase(attributes.getValue("criticality"));
            }
        };
    }

    static LDAPXMLHandler getXMLEntryHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String dn;
            ArrayList valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                LDAPAttributeSet attrset = new LDAPAttributeSet();
                attrset.addAll((Collection)this.valuelist);
                LDAPEntry entry = new LDAPEntry(this.dn, attrset);
                this.setObject(entry);
                this.valuelist.clear();
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.dn = attributes.getValue("dn");
                if (this.dn == null) {
                    throw new SAXException("invalid entry Tag, dn is mandatory element: ");
                }
            }
        };
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String header = "";
        header = header + "*************************************************************************\n";
        header = header + "** The encrypted data above and below is the Class definition and  ******\n";
        header = header + "** other data specific to Java Serialization Protocol. The data  ********\n";
        header = header + "** which is of most application specific interest is as follows... ******\n";
        header = header + "*************************************************************************\n";
        header = header + "****************** Start of application data ****************************\n";
        header = header + "*************************************************************************\n";
        buff.append(header);
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("<LDAPSearchResults>");
        buff.append(ValueXMLhandler.newLine(1));
        while (this.hasMore()) {
            LDAPEntry entry = null;
            try {
                entry = this.next();
            }
            catch (LDAPException le) {
                continue;
            }
            buff.append("<LDAPEntry dn=\"");
            buff.append(entry.getDN());
            buff.append("\">");
            Iterator i = entry.getAttributeSet().iterator();
            while (i.hasNext()) {
                this.writeAttribute((LDAPAttribute)i.next(), buff);
            }
            buff.append(ValueXMLhandler.newLine(1));
            buff.append("</LDAPEntry>");
            buff.append(ValueXMLhandler.newLine(1));
        }
        LDAPControl[] controls = this.getResponseControls();
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                this.writeControl(controls[i], buff);
            }
        }
        buff.append("</LDAPSearchResults>");
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String tail = "";
        tail = tail + "*************************************************************************\n";
        tail = tail + "****************** End of application data ******************************\n";
        tail = tail + "*************************************************************************\n";
        buff.append(tail);
        buff.append(ValueXMLhandler.newLine(0));
        out.write(buff.toString().getBytes());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ObjectInputStream reader = (ObjectInputStream)in;
        StringBuffer rawBuff = new StringBuffer();
        while (reader.available() != 0) {
            rawBuff.append((char)reader.read());
        }
        String readData = rawBuff.toString();
        readData = readData.substring(readData.indexOf(60), readData.lastIndexOf(62) + 1);
        StringBuffer parsedBuff = new StringBuffer();
        ValueXMLhandler.parseInput(readData, parsedBuff);
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(parsedBuff.toString().getBytes()));
        Vector readList = (Vector)LDAPSearchResults.readDSML(istream);
        Vector<LDAPEntry> ldapEntries = new Vector<LDAPEntry>();
        ArrayList<LDAPControl> controlList = new ArrayList<LDAPControl>();
        Enumeration it = readList.elements();
        while (it.hasMoreElements()) {
            Object ob = it.nextElement();
            if (ob instanceof LDAPEntry) {
                ldapEntries.add((LDAPEntry)ob);
                continue;
            }
            if (!(ob instanceof LDAPControl)) continue;
            controlList.add((LDAPControl)ob);
        }
        this.entries = ldapEntries;
        this.controls = new LDAPControl[controlList.size()];
        for (int i = 0; i < controlList.size(); ++i) {
            this.controls[i] = (LDAPControl)controlList.get(i);
        }
        readList = null;
        ldapEntries = null;
        controlList = null;
    }

    public Vector getDeSerializedEntries() {
        return this.entries;
    }

    public LDAPControl[] getDeSerializedControls() {
        return this.controls;
    }
}

