/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.test;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.ImageCommand;
import org.im4java.process.ProcessEvent;
import org.im4java.process.ProcessEventListener;
import org.im4java.process.ProcessExecutor;
import org.im4java.process.ProcessStarter;
import org.im4java.process.ProcessTask;
import org.im4java.test.AbstractTestCase;
import org.im4java.utils.ExtensionFilter;
import org.im4java.utils.FilenameLoader;
import org.im4java.utils.FilenamePatternResolver;

public class TestCase21
extends AbstractTestCase
implements ProcessEventListener {
    protected IMOperation iOp = new IMOperation();
    private List<String> iImages;

    public TestCase21() {
        this.iOp.size(80);
        this.iOp.addImage();
        this.iOp.thumbnail(80);
        this.iOp.addImage();
    }

    @Override
    public String getDescription() {
        return "parallel processes";
    }

    public static void main(String[] stringArray) {
        TestCase21 testCase21 = new TestCase21();
        testCase21.runTest(stringArray);
    }

    protected List<String> load() {
        String string = iImageDir;
        boolean bl = false;
        if (this.iArgs != null && this.iArgs.length > 0) {
            string = this.iArgs[0];
        }
        if (this.iArgs != null && this.iArgs.length > 1) {
            bl = Boolean.parseBoolean(this.iArgs[1]);
        }
        ExtensionFilter extensionFilter = new ExtensionFilter("jpg", "sh", "cmd");
        extensionFilter.setRecursion(bl);
        extensionFilter.ignoreDotDirs(true);
        FilenameLoader filenameLoader = new FilenameLoader(extensionFilter);
        return filenameLoader.loadFilenames(string);
    }

    @Override
    public void run() throws Exception {
        System.err.println("21. Testing parallel processes ...");
        this.iImages = this.load();
        String string = iImageDir + ".thumbnails" + File.separatorChar;
        new File(string).mkdir();
        FilenamePatternResolver filenamePatternResolver = new FilenamePatternResolver(string + "%F");
        ProcessExecutor processExecutor = new ProcessExecutor();
        ProcessStarter.setPIDCounter(0);
        for (String string2 : this.iImages) {
            System.out.println("processing " + string2);
            ConvertCmd convertCmd = new ConvertCmd();
            convertCmd.addProcessEventListener(this);
            ProcessTask processTask = convertCmd.getProcessTask(this.iOp, string2, filenamePatternResolver.createName(string2));
            processExecutor.execute(processTask);
        }
        processExecutor.shutdown();
    }

    @Override
    public void processInitiated(ProcessEvent processEvent) {
    }

    @Override
    public void processStarted(ProcessEvent processEvent) {
    }

    @Override
    public void processTerminated(ProcessEvent processEvent) {
        if (processEvent.getReturnCode() != 0) {
            System.err.println("conversion failed for " + this.iImages.get(processEvent.getPID()));
            ImageCommand imageCommand = (ImageCommand)processEvent.getProcessStarter();
            ArrayList<String> arrayList = imageCommand.getErrorText();
            if (arrayList != null && arrayList.size() > 0) {
                System.err.println("  printing errors:");
                for (String string : arrayList) {
                    System.err.println("  " + string);
                }
            }
        } else {
            System.err.println("conversion successful for " + this.iImages.get(processEvent.getPID()));
        }
    }
}

