/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.webdav;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HttpRequestFixer
extends HttpServletRequestWrapper {
    private static final Pattern UPPERCASE_ENCODED_CHARS_PATTERN = Pattern.compile("%[0-9A-F][0-9A-F]");

    public HttpRequestFixer(HttpServletRequest request) {
        super(request);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (("Lock-Token".equals(name) || "If".equals(name)) && value != null) {
            HashMap<String, String> fixes = new HashMap<String, String>();
            Matcher matcher = UPPERCASE_ENCODED_CHARS_PATTERN.matcher(value);
            while (matcher.find()) {
                String lowerCase;
                String match = matcher.group();
                if (fixes.containsKey(match) || match.equals(lowerCase = match.toLowerCase())) continue;
                fixes.put(match, lowerCase);
            }
            for (Map.Entry entry : fixes.entrySet()) {
                value = value.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        return value;
    }
}

