/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.ComponentAuthorization;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.util.MapUtil;
import org.silverpeas.kernel.util.StringUtil;

@Named
public class KmeliaComponentAuthorization
implements ComponentAuthorization {
    private static final String PUBLICATION_TYPE = "Publication";
    private static final String NODE_TYPE = "Node";
    private static final String ATTACHMENT_TYPE = "Attachment";
    private static final String VERSION_TYPE = "Version";

    private KmeliaComponentAuthorization() {
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("kmelia");
    }

    public <T> Stream<T> filter(Collection<T> resources, Function<T, ComponentAuthorization.ComponentResourceReference> converter, String userId, AccessControlOperation ... operations) {
        HashMap pubPks = new HashMap(resources.size());
        HashMap nodePks = new HashMap(resources.size());
        HashMap instanceIds = new HashMap(resources.size());
        HashSet authorized = new HashSet(resources.size());
        resources.forEach(r -> {
            ComponentAuthorization.ComponentResourceReference resourceRef = (ComponentAuthorization.ComponentResourceReference)converter.apply(r);
            String resourceType = resourceRef.getType();
            if (this.isHandledKmeliaResourceType(resourceType)) {
                if (StringUtil.isLong((String)resourceRef.getLocalId())) {
                    MapUtil.putAddSet((Map)pubPks, (Object)new ResourceRefHash(resourceRef.getLocalId(), resourceRef.getInstanceId()), (Object)resourceRef);
                }
            } else if (NODE_TYPE.equalsIgnoreCase(resourceType)) {
                MapUtil.putAddSet((Map)nodePks, (Object)new ResourceRefHash(resourceRef.getLocalId(), resourceRef.getInstanceId()), (Object)resourceRef);
            } else if (StringUtil.isDefined((String)resourceRef.getInstanceId())) {
                MapUtil.putAddSet((Map)instanceIds, (Object)resourceRef.getInstanceId(), (Object)resourceRef);
            } else {
                authorized.add(resourceRef);
            }
        });
        PublicationAccessControl.get().filterAuthorizedByUser(ResourceRefHash.toPublicationPKs(pubPks.keySet()), userId, AccessControlContext.init().onOperationsOf(operations)).forEach(p -> authorized.addAll((Collection)pubPks.get(new ResourceRefHash((ResourceReference)p))));
        NodeAccessControl.get().filterAuthorizedByUser(ResourceRefHash.toNodePks(nodePks.keySet()), userId, AccessControlContext.init().onOperationsOf(operations)).forEach(p -> authorized.addAll((Collection)nodePks.get(new ResourceRefHash((ResourceReference)p))));
        ComponentAccessControl.get().filterAuthorizedByUser(instanceIds.keySet(), userId, AccessControlContext.init().onOperationsOf(operations)).forEach(p -> authorized.addAll((Collection)instanceIds.get(p)));
        return resources.stream().filter(r -> authorized.contains(converter.apply(r)));
    }

    private boolean isHandledKmeliaResourceType(String objectType) {
        return objectType != null && (PUBLICATION_TYPE.equalsIgnoreCase(objectType) || objectType.startsWith(ATTACHMENT_TYPE) || objectType.startsWith(VERSION_TYPE));
    }

    private static class ResourceRefHash
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String localId;
        private final String instanceId;

        public static List<PublicationPK> toPublicationPKs(Collection<ResourceRefHash> hashes) {
            return hashes.stream().map(ResourceRefHash::toPublicationPK).collect(Collectors.toList());
        }

        public static List<NodePK> toNodePks(Collection<ResourceRefHash> hashes) {
            return hashes.stream().map(ResourceRefHash::toNodePK).collect(Collectors.toList());
        }

        public ResourceRefHash(String localId, String instanceId) {
            this.localId = localId;
            this.instanceId = instanceId;
        }

        public ResourceRefHash(ResourceReference resourceRef) {
            this.localId = resourceRef.getLocalId();
            this.instanceId = resourceRef.getInstanceId();
        }

        public PublicationPK toPublicationPK() {
            return new PublicationPK(this.localId, this.instanceId);
        }

        public NodePK toNodePK() {
            return new NodePK(this.localId, this.instanceId);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceRefHash that = (ResourceRefHash)o;
            return Objects.equals(this.localId, that.localId) && Objects.equals(this.instanceId, that.instanceId);
        }

        public int hashCode() {
            return Objects.hash(this.localId, this.instanceId);
        }
    }
}

