/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration.report;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.oak.plugins.migration.report.Reporter;
import org.apache.jackrabbit.oak.plugins.migration.report.ReportingNodeState;
import org.jetbrains.annotations.NotNull;

public abstract class PeriodicReporter
implements Reporter {
    private final int nodeLogInterval;
    private final int propertyLogInterval;
    private AtomicLong nodes = new AtomicLong(0L);
    private AtomicLong properties = new AtomicLong(0L);

    protected PeriodicReporter(int nodeLogInterval, int propertyLogInterval) {
        this.nodeLogInterval = nodeLogInterval;
        this.propertyLogInterval = propertyLogInterval;
    }

    protected void reset() {
        this.nodes.set(0L);
        this.properties.set(0L);
    }

    protected abstract void reportPeriodicNode(long var1, @NotNull ReportingNodeState var3);

    protected abstract void reportPeriodicProperty(long var1, @NotNull ReportingNodeState var3, @NotNull String var4);

    protected boolean skipNodeState(@NotNull ReportingNodeState nodeState) {
        return false;
    }

    @Override
    public final void reportNode(@NotNull ReportingNodeState nodeState) {
        if (this.nodeLogInterval == -1) {
            return;
        }
        if (this.skipNodeState(nodeState)) {
            return;
        }
        long count = this.nodes.incrementAndGet();
        if (count % (long)this.nodeLogInterval == 0L) {
            this.reportPeriodicNode(count, nodeState);
        }
    }

    @Override
    public final void reportProperty(@NotNull ReportingNodeState parent, @NotNull String propertyName) {
        if (this.propertyLogInterval == -1) {
            return;
        }
        long count = this.properties.incrementAndGet();
        if (count % (long)this.propertyLogInterval == 0L) {
            this.reportPeriodicProperty(count, parent, propertyName);
        }
    }
}

