/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.toggle;

import java.io.Closeable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.oak.spi.toggle.FeatureToggle;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;

public final class Feature
implements Closeable {
    private final AtomicBoolean value;
    private final Registration registration;

    private Feature(AtomicBoolean value, Registration registration) {
        this.value = value;
        this.registration = registration;
    }

    public static Feature newFeature(String name, Whiteboard whiteboard) {
        AtomicBoolean value = new AtomicBoolean();
        FeatureToggle adapter = new FeatureToggle(name, value);
        return new Feature(value, whiteboard.register(FeatureToggle.class, adapter, Collections.emptyMap()));
    }

    public boolean isEnabled() {
        return this.value.get();
    }

    @Override
    public void close() {
        this.registration.unregister();
    }
}

