/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.jetbrains.annotations.NotNull;

final class TokenContext
implements Context {
    private static final Context INSTANCE = new TokenContext();

    private TokenContext() {
    }

    static Context getInstance() {
        return INSTANCE;
    }

    public boolean definesProperty(@NotNull Tree parent, @NotNull PropertyState property) {
        return TokenContext.isTokenNode(parent);
    }

    public boolean definesContextRoot(@NotNull Tree tree) {
        return ".tokens".equals(tree.getName());
    }

    public boolean definesTree(@NotNull Tree tree) {
        return this.definesContextRoot(tree) || TokenContext.isTokenNode(tree);
    }

    public boolean definesLocation(@NotNull TreeLocation location) {
        PropertyState ps = location.getProperty();
        TreeLocation l = ps != null ? location.getParent() : location;
        Tree t = l.getTree();
        if (t == null) {
            return false;
        }
        return ps == null ? this.definesTree(t) : this.definesProperty(t, ps);
    }

    public boolean definesInternal(@NotNull Tree tree) {
        return false;
    }

    private static boolean isTokenNode(@NotNull Tree tree) {
        return "rep:Token".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
    }
}

