/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.notification;

import org.silverpeas.components.gallery.model.AlbumMedia;
import org.silverpeas.components.gallery.notification.AlbumMediaEvent;
import org.silverpeas.components.gallery.notification.user.AlbumMediaNotificationManager;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.notification.system.CDIResourceEventListener;

@Bean
public class AlbumMediaEventListener
extends CDIResourceEventListener<AlbumMediaEvent> {
    public void onCreation(AlbumMediaEvent event) {
        AlbumMedia albumMedia = (AlbumMedia)event.getTransition().getAfter();
        User modifier = this.getModifier(albumMedia);
        AlbumMediaNotificationManager.get().putCreationOf(albumMedia, modifier);
    }

    public void onDeletion(AlbumMediaEvent event) {
        AlbumMedia albumMedia = (AlbumMedia)event.getTransition().getBefore();
        User modifier = this.getModifier(albumMedia);
        AlbumMediaNotificationManager.get().putDeletionOf(albumMedia, modifier);
    }

    private User getModifier(AlbumMedia albumMedia) {
        User sender = User.getCurrentRequester();
        if (sender == null) {
            sender = albumMedia.getMedia().getLastUpdater();
        }
        return sender;
    }
}

