/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tree.TreeAware;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    @NotNull
    static Tree getOrAddTree(@NotNull Tree tree, @NotNull String relativePath, @NotNull String primaryTypeName) throws AccessDeniedException {
        if (PathUtils.denotesCurrent((String)relativePath)) {
            return tree;
        }
        if (PathUtils.denotesParent((String)relativePath)) {
            return tree.getParent();
        }
        if (relativePath.indexOf(47) == -1) {
            return TreeUtil.getOrAddChild((Tree)tree, (String)relativePath, (String)primaryTypeName);
        }
        for (String element : PathUtils.elements((String)relativePath)) {
            if (PathUtils.denotesParent((String)element)) {
                tree = tree.getParent();
                continue;
            }
            if (PathUtils.denotesCurrent((String)element)) continue;
            tree = TreeUtil.getOrAddChild((Tree)tree, (String)element, (String)primaryTypeName);
        }
        return tree;
    }

    static boolean canHavePasswordExpired(@NotNull String userId, @NotNull ConfigurationParameters config) {
        return !UserUtil.isAdmin((ConfigurationParameters)config, (String)userId) || (Boolean)config.getConfigValue("passwordExpiryForAdmin", (Object)false) != false;
    }

    static boolean canHavePasswordExpired(@NotNull User user, @NotNull ConfigurationParameters config) {
        return !user.isAdmin() || (Boolean)config.getConfigValue("passwordExpiryForAdmin", (Object)false) != false;
    }

    static boolean isEveryone(@NotNull Authorizable authorizable) {
        return authorizable.isGroup() && "everyone".equals(Utils.getPrincipalName(authorizable));
    }

    public static boolean canImpersonateAllUsers(@NotNull Principal principal, @NotNull UserManager userManager) {
        try {
            Authorizable authorizable = userManager.getAuthorizable(principal);
            return authorizable != null && !authorizable.isGroup() && ((User)authorizable).isAdmin();
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return false;
        }
    }

    @Nullable
    private static String getPrincipalName(@NotNull Authorizable authorizable) {
        if (authorizable instanceof AuthorizableImpl) {
            return ((AuthorizableImpl)authorizable).getPrincipalNameOrNull();
        }
        try {
            return authorizable.getPrincipal().getName();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Nullable
    static String getIdOrNull(@NotNull Authorizable authorizable) {
        try {
            return authorizable.getID();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @NotNull
    static Tree getTree(@NotNull Authorizable authorizable, @NotNull Root root) throws RepositoryException {
        if (authorizable instanceof TreeAware) {
            return ((TreeAware)authorizable).getTree();
        }
        return root.getTree(authorizable.getPath());
    }
}

