/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.navigation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.common.navigation.InvalidNavigationException;
import org.odftoolkit.simple.common.navigation.Selection;
import org.odftoolkit.simple.common.navigation.TextSelection;
import org.odftoolkit.simple.text.Paragraph;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextDocumentSelection
extends Selection {
    private TextSelection textSelection;
    private TextDocument sourceDocument;

    public void replaceWithTextDocument(TextDocument textDocument) throws Exception {
        this.sourceDocument = textDocument;
        int leftLength = this.textSelection.getText().length();
        int index = this.textSelection.getIndex();
        this.prepareParagraphContainer(leftLength, index);
    }

    public TextDocumentSelection(TextSelection selection) {
        this.textSelection = selection;
    }

    @Override
    public void cut() throws InvalidNavigationException {
        this.textSelection.cut();
    }

    @Override
    public void pasteAtEndOf(Selection positionItem) throws InvalidNavigationException {
        this.textSelection.pasteAtEndOf(positionItem);
    }

    private void delete(int fromIndex, int leftLength, Node pNode) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                fromIndex = 0;
                if (nextLength >= 0) {
                    buffer.append(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    leftLength = endLength - value.length();
                }
                node.setNodeValue(buffer.toString());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                leftLength -= nodeLength - fromIndex;
                fromIndex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromIndex = 0;
                --leftLength;
                continue;
            }
            this.delete(fromIndex, leftLength, node);
            int length = fromIndex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromIndex = 0;
        }
    }

    @Override
    public void pasteAtFrontOf(Selection positionItem) throws InvalidNavigationException {
        this.textSelection.pasteAtFrontOf(positionItem);
    }

    @Override
    protected void refresh(int offset) {
        this.textSelection.refresh(offset);
    }

    @Override
    protected void refreshAfterFrontalDelete(Selection deletedItem) {
        this.textSelection.refreshAfterFrontalDelete(deletedItem);
    }

    @Override
    protected void refreshAfterFrontalInsert(Selection insertedItem) {
        this.textSelection.refreshAfterFrontalInsert(insertedItem);
    }

    private void prepareParagraphContainer(int leftLength, int index) throws Exception {
        OdfElement node;
        OdfElement rightparentElement = this.textSelection.getContainerElement();
        int nodeLength = TextExtractor.getText(rightparentElement).length();
        Paragraph orgparagraph = Paragraph.getInstanceof((TextParagraphElementBase)rightparentElement);
        TextDocument document = (TextDocument)orgparagraph.getOwnerDocument();
        OfficeTextElement sroot = this.sourceDocument.getContentRoot();
        NodeList clist = sroot.getChildNodes();
        try {
            OfficeTextElement documentRoot = document.getContentRoot();
            Node rootNode = rightparentElement.getParentNode();
            if (!rootNode.equals(documentRoot)) {
                throw new RuntimeException("The ParentNode of text content's ContainerElement which will be replaced is not Document ContentRoot, TextDocument only can be insert to the Docuemnt ContentRoot");
            }
        }
        catch (Exception e) {
            Logger.getLogger(TextDocumentSelection.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        if (index == 0) {
            if (leftLength == nodeLength) {
                TextParagraphElementBase refElement = orgparagraph.getOdfElement();
                for (int i = 0; i < clist.getLength(); ++i) {
                    OdfElement node2 = (OdfElement)clist.item(i);
                    refElement = document.insertOdfElement((OdfElement)refElement, this.sourceDocument, node2, false);
                }
                rightparentElement.getParentNode().removeChild((Node)rightparentElement);
            } else {
                this.delete(index, leftLength, (Node)rightparentElement);
                for (int i = 0; i < clist.getLength(); ++i) {
                    node = (OdfElement)clist.item(i);
                    document.insertOdfElement((OdfElement)orgparagraph.getOdfElement(), this.sourceDocument, node, true);
                }
            }
        } else if (nodeLength == index + leftLength) {
            this.delete(index, leftLength, (Node)rightparentElement);
            for (int i = 0; i < clist.getLength(); ++i) {
                node = (OdfElement)clist.item(i);
                document.insertOdfElement((OdfElement)orgparagraph.getOdfElement(), this.sourceDocument, node, false);
            }
        } else {
            this.delete(index, leftLength, (Node)rightparentElement);
            Node leftparentElement = rightparentElement.cloneNode(true);
            rightparentElement.getParentNode().insertBefore(leftparentElement, (Node)rightparentElement);
            nodeLength = TextExtractor.getText((OdfElement)leftparentElement).length();
            this.delete(index, nodeLength - index, leftparentElement);
            this.delete(0, index, (Node)rightparentElement);
            for (int i = 0; i < clist.getLength(); ++i) {
                OdfElement node3 = (OdfElement)clist.item(i);
                document.insertOdfElement((OdfElement)orgparagraph.getOdfElement(), this.sourceDocument, node3, true);
            }
            int offset = 0 - leftLength - index;
            this.sourceDocument.getSelectionManager().refresh(rightparentElement, offset, offset);
        }
    }
}

