/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.IOException;
import java.util.Properties;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;

class Manifest {
    private static final String STORE_VERSION = "store.version";
    private final Properties properties;

    static Manifest load(ManifestFile file) throws IOException {
        return new Manifest(file.load());
    }

    static Manifest empty() {
        return new Manifest(new Properties());
    }

    private Manifest(Properties properties) {
        this.properties = properties;
    }

    int getStoreVersion(int otherwise) {
        return this.getIntegerProperty(STORE_VERSION, otherwise);
    }

    void setStoreVersion(int version) {
        this.setIntegerProperty(STORE_VERSION, version);
    }

    void save(ManifestFile file) throws IOException {
        file.save(this.properties);
    }

    private int getIntegerProperty(String name, int otherwise) {
        Object value = this.properties.get(name);
        if (value == null) {
            return otherwise;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            return otherwise;
        }
    }

    private void setIntegerProperty(String name, int value) {
        this.properties.put(name, Integer.toString(value));
    }
}

