/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.gradle.internal.classpath.Instrumented;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaDeprecation {
    private static final Logger LOG;
    private static final String DEFAULT = "error";
    private static final String TLOGLEVEL;
    private static String LOGLEVEL;

    private GuavaDeprecation() {
    }

    public static void handleCall(String ticket) throws UnsupportedOperationException {
        GuavaDeprecation.handleCall(ticket, null, Collections.emptyList());
    }

    public static void handleCall(String ticket, String className, List<String> allowed) throws UnsupportedOperationException {
        String message = "use of deprecated Guava-related API - this method is going to be removed in future Oak releases - see %s for details";
        switch (LOGLEVEL) {
            case "error": {
                Exception ex;
                if (!LOG.isErrorEnabled() || !GuavaDeprecation.deprecatedCaller(ex = new Exception("call stack"), className, allowed)) break;
                LOG.error(String.format(message, ticket), (Throwable)ex);
                break;
            }
            case "warn": {
                Exception ex;
                if (!LOG.isWarnEnabled() || !GuavaDeprecation.deprecatedCaller(ex = new Exception("call stack"), className, allowed)) break;
                LOG.warn(String.format(message, ticket), (Throwable)ex);
                break;
            }
            case "info": {
                Exception ex;
                if (!LOG.isInfoEnabled() || !GuavaDeprecation.deprecatedCaller(ex = new Exception("call stack"), className, allowed)) break;
                LOG.info(String.format(message, ticket), (Throwable)ex);
                break;
            }
            case "debug": {
                Exception ex;
                if (!LOG.isDebugEnabled() || !GuavaDeprecation.deprecatedCaller(ex = new Exception("call stack"), className, allowed)) break;
                LOG.debug(String.format(message, ticket), (Throwable)ex);
            }
        }
    }

    public static boolean deprecatedCaller(Exception ex, String className, List<String> allowed) {
        if (allowed == null) {
            return true;
        }
        boolean classFound = false;
        for (StackTraceElement el : ex.getStackTrace()) {
            String cn = el.getClassName();
            if (!classFound) {
                classFound = cn.equals(className);
                continue;
            }
            if (cn.equals(className)) continue;
            for (String a : allowed) {
                if (!cn.startsWith(a)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        String t;
        LOG = LoggerFactory.getLogger(GuavaDeprecation.class);
        TLOGLEVEL = Instrumented.systemProperty((String)(GuavaDeprecation.class + ".LOGLEVEL"), (String)DEFAULT, (String)"org.apache.jackrabbit.oak.spi.GuavaDeprecation");
        switch (TLOGLEVEL.toLowerCase(Locale.ENGLISH)) {
            case "error": 
            case "warn": {
                t = TLOGLEVEL.toLowerCase(Locale.ENGLISH);
                break;
            }
            default: {
                t = DEFAULT;
            }
        }
        LOGLEVEL = t;
    }
}

