/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ttl.turtle;

import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.graph.Graph;
import org.apache.jena.ttl.turtle.TurtleParseException;
import org.apache.jena.ttl.turtle.TurtleRDFGraphInserter;
import org.apache.jena.ttl.turtle.parser.ParseException;
import org.apache.jena.ttl.turtle.parser.TokenMgrError;
import org.apache.jena.ttl.turtle.parser.TurtleParser;
import org.apache.jena.util.FileUtils;

public class ParserTurtle {
    public void parse(Graph graph, String baseURI, InputStream in) {
        Reader reader = FileUtils.asUTF8(in);
        this.parse(graph, baseURI, reader);
    }

    public void parse(Graph graph, String baseURI, Reader reader) {
        try {
            TurtleParser parser = new TurtleParser(reader);
            parser.setEventHandler(new TurtleRDFGraphInserter(graph));
            parser.setBaseURI(baseURI);
            parser.parse();
        }
        catch (ParseException | TokenMgrError ex) {
            throw new TurtleParseException(ex.getMessage());
        }
        catch (TurtleParseException ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw new TurtleParseException(th.getMessage(), th);
        }
    }
}

