/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCStatus;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.helpers.MessageFormatter;

public class FileStoreGCMonitor
implements GCMonitor {
    private final Clock clock;
    private long lastCompaction;
    private long lastCleanup;
    private long lastRepositorySize;
    private long lastReclaimedSize;
    private String lastError;
    private String lastLogMessage;
    private String status = SegmentGCStatus.IDLE.message();

    public FileStoreGCMonitor(@NotNull Clock clock) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    public void info(String message, Object ... arguments) {
        this.lastLogMessage = MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage();
    }

    public void warn(String message, Object ... arguments) {
        this.lastLogMessage = MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage();
    }

    public void error(String message, Exception exception) {
        StringWriter sw = new StringWriter();
        sw.write(message + ": ");
        exception.printStackTrace(new PrintWriter(sw));
        this.lastError = sw.toString();
    }

    public void skipped(String reason, Object ... arguments) {
        this.lastLogMessage = MessageFormatter.arrayFormat((String)reason, (Object[])arguments).getMessage();
    }

    public void compacted() {
        this.lastCompaction = this.clock.getTime();
    }

    public void cleaned(long reclaimed, long current) {
        this.lastCleanup = this.clock.getTime();
        this.lastReclaimedSize = reclaimed;
        this.lastRepositorySize = current;
    }

    public void updateStatus(String status) {
        this.status = status;
    }

    public long getLastCompaction() {
        return this.lastCompaction;
    }

    public long getLastCleanup() {
        return this.lastCleanup;
    }

    public long getLastRepositorySize() {
        return this.lastRepositorySize;
    }

    public long getLastReclaimedSize() {
        return this.lastReclaimedSize;
    }

    public String getLastError() {
        return this.lastError;
    }

    @NotNull
    public String getLastLogMessage() {
        return this.lastLogMessage;
    }

    @NotNull
    public String getStatus() {
        return this.status;
    }
}

