/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs;

import edu.psu.swe.commons.jaxrs.AtomLink;
import edu.psu.swe.commons.jaxrs.adapters.InstantFormatAdapter;
import edu.psu.swe.commons.jaxrs.enumerations.RelationshipType;
import edu.psu.swe.commons.jaxrs.utilities.UriUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Base64;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestResourceMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(RestResourceMetadata.class);
    @XmlElement(nillable=true)
    private String resourceType;
    @XmlElement(nillable=true)
    @XmlJavaTypeAdapter(value=InstantFormatAdapter.class)
    private Instant created;
    @XmlElement(nillable=true)
    @XmlJavaTypeAdapter(value=InstantFormatAdapter.class)
    private Instant lastUpdated;
    @XmlElement(nillable=true)
    private String version;

    public RestResourceMetadata() {
    }

    public RestResourceMetadata(RestResourceMetadata other) {
        this.resourceType = other.getResourceType();
        this.created = other.getCreated();
        this.lastUpdated = other.getLastUpdated();
        this.version = other.getVersion();
    }

    public RestResourceMetadata(String resourceType, Instant created, Instant lastUpdated, String version) {
        this.resourceType = resourceType;
        this.created = created;
        this.lastUpdated = lastUpdated;
        this.version = version;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public Instant getCreated() {
        return this.created;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public Instant getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Instant lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static EntityTag hash(Object object) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return RestResourceMetadata.hash(object.toString());
    }

    public static EntityTag hash(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(input.getBytes("UTF-8"));
        byte[] hash = digest.digest();
        return new EntityTag(Base64.getEncoder().encodeToString(hash));
    }

    public static RestResourceMetadata createMetaData(EntityTag etag, String type) {
        RestResourceMetadata meta = new RestResourceMetadata();
        if (etag != null) {
            meta.setVersion(etag.toString());
        }
        meta.setCreated(Instant.now());
        meta.setResourceType(type);
        return meta;
    }

    public static AtomLink createSelfLink(UriInfo uriInfo) {
        String url = null;
        try {
            url = UriUtil.urlAsString(uriInfo, true);
        }
        catch (MalformedURLException mue) {
            LOG.info("Failed to convert url " + mue.getLocalizedMessage());
        }
        AtomLink self = new AtomLink();
        self.setRelation(RelationshipType.SELF.toString());
        self.setHyperlink(url);
        self.setMimeType("application/edu-psu-swe-v1+json");
        return self;
    }
}

