/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.processmanager.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.model.UnlockContext;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.field.FileField;
import org.silverpeas.core.contribution.content.form.form.XmlForm;
import org.silverpeas.core.contribution.content.form.record.GenericDataRecord;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.workflow.api.Workflow;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.event.TaskDoneEvent;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.api.task.Task;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.user.UserImpl;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;
import org.silverpeas.processmanager.ProcessManagerException;
import org.silverpeas.processmanager.service.FileContent;
import org.silverpeas.processmanager.service.ProcessManagerService;

@Service
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultProcessManagerService
implements ProcessManagerService {
    public static final String DEFAULT_ROLE = "supervisor";
    private static final String FR_LANG = "fr";
    private static final String FIELD_TYPE = ", field type: ";
    private static final String DEFAULT_PROCESS_MANAGER_SERVICE = "DefaultProcessManagerService";
    private static final String FIELD_NAME = "field name: ";

    @Override
    public String createProcess(String componentId, String userId, String fileName, byte[] fileContent) throws ProcessManagerException, WorkflowException, InterruptedException {
        HashMap<String, Object> metadata = new HashMap<String, Object>(1);
        metadata.put(null, new FileContent(fileName, fileContent));
        return this.createProcess(componentId, userId, DEFAULT_ROLE, metadata);
    }

    @Override
    public String createProcess(String componentId, String userId, String userRole, Map<String, Object> metadata) throws ProcessManagerException, WorkflowException, InterruptedException {
        if (metadata == null) {
            metadata = Collections.emptyMap();
        }
        ProcessModel processModel = this.getProcessModel(componentId);
        XmlForm form = (XmlForm)this.getCreationForm(processModel, userRole);
        GenericDataRecord data = (GenericDataRecord)this.getEmptyCreationRecord(processModel, userRole);
        String instanceId = this.createProcessInstance(processModel, userId, userRole, (DataRecord)data);
        List<String> attachmentIds = this.populateFields(instanceId, componentId, userId, metadata, data, form);
        for (String attachmentId : attachmentIds) {
            SimpleDocumentPK pk = new SimpleDocumentPK(attachmentId, componentId);
            SimpleDocument document = AttachmentServiceProvider.getAttachmentService().searchDocumentById(pk, null);
            document.setForeignId(instanceId);
            AttachmentServiceProvider.getAttachmentService().lock(attachmentId, userId, null);
            AttachmentServiceProvider.getAttachmentService().updateAttachment(document, false, false);
            AttachmentServiceProvider.getAttachmentService().unlock(new UnlockContext(attachmentId, userId, null));
        }
        this.getProcessInstance(instanceId).updateFolder((DataRecord)data);
        Thread.sleep(4000L);
        return instanceId;
    }

    @Override
    public void doAction(String action, String processId, String componentId, String userId, String userRole, Map<String, Object> metadata) throws ProcessManagerException {
        try {
            ProcessModel processModel = this.getProcessModel(componentId);
            ProcessInstance processInstance = Workflow.getProcessInstanceManager().getProcessInstance(processId);
            XmlForm form = (XmlForm)this.getActionForm(processModel, action, userRole);
            GenericDataRecord data = (GenericDataRecord)processModel.getNewActionRecord(action, userRole, this.getLanguage(), null);
            this.populateFields(processId, componentId, userId, metadata, data, form);
            this.doAction(action, processInstance, processModel, userId, userRole, (DataRecord)data);
        }
        catch (WorkflowException we) {
            throw new ProcessManagerException(this.getClass().getName(), "processManager.CANT_EXECUTE_ACTION", "action: " + action + ", processInstanceId: " + processId);
        }
        catch (ProcessManagerException e) {
            SilverLogger.getLogger((Object)this).error("DefaultProcessManagerService.doAction()", (Throwable)((Object)e));
            throw e;
        }
    }

    @Override
    public ProcessInstance getProcessInstance(String processId) throws ProcessManagerException {
        try {
            return Workflow.getProcessInstanceManager().getProcessInstance(processId);
        }
        catch (WorkflowException we) {
            throw new ProcessManagerException(this.getClass().getName(), "processManager.CANT_GET_INSTANCE", "processInstanceId: " + processId);
        }
    }

    private String retrieveMatchingFieldTypeName(Object value) throws ProcessManagerException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "text";
        }
        if (value instanceof Date) {
            return "date";
        }
        if (value instanceof FileContent) {
            return "file";
        }
        if (value instanceof Group) {
            return "group";
        }
        if (value instanceof User) {
            return "user";
        }
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            if (col.isEmpty()) {
                return null;
            }
            return this.retrieveMatchingFieldTypeName(col.iterator().next());
        }
        throw new ProcessManagerException(DEFAULT_PROCESS_MANAGER_SERVICE, "processManager.FORM_FIELD_BAD_TYPE", "type: " + value.getClass().getName());
    }

    private Field findMatchingField(XmlForm form, GenericDataRecord data, String name, String typeName) throws ProcessManagerException {
        for (FieldTemplate fieldTemplate : form.getFieldTemplates()) {
            String fieldType = fieldTemplate.getTypeName();
            if ("pdc".equals(fieldType)) {
                fieldType = "text";
            }
            String fieldName = fieldTemplate.getFieldName();
            if (typeName != null && !fieldType.equals(typeName) || !fieldName.equals(name) && (name != null || !fieldTemplate.isMandatory())) continue;
            try {
                return data.getField(fieldName);
            }
            catch (FormException e) {
                throw new ProcessManagerException("Form field bad type: field name: " + name + FIELD_TYPE + typeName, e);
            }
        }
        throw new ProcessManagerException("Form field not found: field name: " + name + FIELD_TYPE + typeName, new String[0]);
    }

    private String getSimpleFieldValueString(Object value, String type) {
        if (value != null) {
            if ("text".equals(type)) {
                return value.toString();
            }
            if ("date".equals(type)) {
                return value instanceof Date ? DateUtil.date2SQLDate((Date)((Date)value)) : value.toString();
            }
            if ("group".equals(type)) {
                return value instanceof Group ? ((Group)value).getId() : value.toString();
            }
        }
        return null;
    }

    private void populateSimpleField(Field field, String name, Object value, String type) throws ProcessManagerException {
        try {
            if (value == null) {
                field.setNull();
            } else {
                field.setStringValue(this.getSimpleFieldValueString(value, type));
            }
        }
        catch (FormException e) {
            throw new ProcessManagerException("Form field error: field name: " + name + FIELD_TYPE + type, e);
        }
    }

    private String populateFileField(XmlForm form, GenericDataRecord data, FileField field, String name, FileContent content, PagesContext pagesContext) throws ProcessManagerException {
        if (name == null) {
            Field fileNameField;
            try {
                fileNameField = this.findMatchingField(form, data, null, "text");
            }
            catch (ProcessManagerException e) {
                fileNameField = null;
            }
            if (fileNameField != null) {
                this.populateSimpleField(fileNameField, null, content.getName(), "text");
            }
        }
        String attachmentId = this.processUploadedFile(content.getContent(), content.getName(), pagesContext);
        field.setAttachmentId(attachmentId);
        return attachmentId;
    }

    private void populateListField(Field field, String name, Collection<?> values, String type) throws ProcessManagerException {
        try {
            StringBuilder valuesStr = new StringBuilder(512);
            for (Object value : values) {
                String str;
                if (valuesStr.length() > 0) {
                    valuesStr.append(',');
                }
                if ((str = this.getSimpleFieldValueString(value, type)) == null) {
                    throw new ProcessManagerException(DEFAULT_PROCESS_MANAGER_SERVICE, "processManager.FORM_FIELD_COLLECTION_NOT_ALLOWED", FIELD_NAME + name + FIELD_TYPE + type);
                }
                valuesStr.append(str);
            }
            field.setStringValue(valuesStr.toString());
        }
        catch (FormException e) {
            throw new ProcessManagerException("Form field error:field name: " + name + FIELD_TYPE + type, e);
        }
    }

    private String createProcessInstance(ProcessModel processModel, String userId, String currentRole, DataRecord data) throws ProcessManagerException {
        try {
            Action creation = processModel.getCreateAction(currentRole);
            TaskDoneEvent event = this.getCreationTask(processModel, userId, currentRole).buildTaskDoneEvent(creation.getName(), data);
            Workflow.getWorkflowEngine().process(event);
            return event.getProcessInstance().getInstanceId();
        }
        catch (WorkflowException e) {
            throw new ProcessManagerException("Fail to create process instance", e);
        }
    }

    private Form getCreationForm(ProcessModel processModel, String role) throws ProcessManagerException {
        try {
            Action creation = processModel.getCreateAction(role);
            return processModel.getPublicationForm(creation.getName(), role, this.getLanguage());
        }
        catch (WorkflowException e) {
            throw new ProcessManagerException(SilverpeasExceptionMessages.failureOnGetting((String)"creation form", (Object)processModel.getModelId()), e);
        }
    }

    private DataRecord getEmptyCreationRecord(ProcessModel processModel, String currentRole) throws ProcessManagerException {
        try {
            Action creation = processModel.getCreateAction(currentRole);
            return processModel.getNewActionRecord(creation.getName(), currentRole, this.getLanguage(), null);
        }
        catch (WorkflowException e) {
            throw new ProcessManagerException(SilverpeasExceptionMessages.failureOnGetting((String)"empty creation record of model", (Object)processModel.getModelId()), e);
        }
    }

    private Task getCreationTask(ProcessModel processModel, String userId, String currentRole) throws ProcessManagerException {
        try {
            UserImpl user = new UserImpl(UserDetail.getById((String)userId));
            return Workflow.getTaskManager().getCreationTask((User)user, currentRole, processModel);
        }
        catch (WorkflowException e) {
            throw new ProcessManagerException(SilverpeasExceptionMessages.failureOnGetting((String)"creation task of model", (Object)processModel.getModelId()), e);
        }
    }

    private ProcessModel getProcessModel(String modelId) throws ProcessManagerException {
        try {
            return Workflow.getProcessModelManager().getProcessModel(modelId);
        }
        catch (WorkflowException e) {
            throw new ProcessManagerException(SilverpeasExceptionMessages.failureOnGetting((String)"process model", (Object)modelId), e);
        }
    }

    private String processUploadedFile(byte[] fileContent, String fileName, PagesContext pagesContext) {
        String attachmentId = null;
        String foreignId = pagesContext.getObjectId();
        String logicalName = fileName;
        if (StringUtil.isDefined((String)logicalName)) {
            logicalName = FileUtil.getFilename((String)fileName);
            String extension = FileRepositoryManager.getFileExtension((String)logicalName);
            String mimeType = FileUtil.getMimeType((String)logicalName);
            if (mimeType.equals("application/x-zip-compressed")) {
                if ("jar".equalsIgnoreCase(extension) || "war".equalsIgnoreCase(extension) || "ear".equalsIgnoreCase(extension)) {
                    mimeType = "application/java-archive";
                } else if ("3D".equalsIgnoreCase(extension)) {
                    mimeType = "application/xview3d-3d";
                }
            }
            SimpleDocument ad = this.createSimpleDocument(foreignId, pagesContext.getComponentId(), logicalName, mimeType, fileContent, pagesContext.getUserId(), pagesContext.isVersioningUsed());
            ad.setDocumentType(DocumentType.form);
            attachmentId = ad.getId();
        }
        return attachmentId;
    }

    private SimpleDocument createSimpleDocument(String foreignId, String componentId, String fileName, String mimeType, byte[] content, String userId, boolean versioned) {
        SimpleDocumentPK simpleDocPk = new SimpleDocumentPK(null, componentId);
        SimpleAttachment attachment = SimpleAttachment.builder((String)this.getLanguage()).setFilename(fileName).setTitle(fileName).setDescription("").setSize((long)content.length).setContentType(mimeType).setCreationData(userId, new Date()).build();
        SimpleDocument doc = new SimpleDocument(simpleDocPk, foreignId, 0, versioned, userId, attachment);
        return AttachmentServiceProvider.getAttachmentService().createAttachment(doc, (InputStream)new ByteArrayInputStream(content));
    }

    private String getLanguage() {
        return FR_LANG;
    }

    private String doAction(String action, ProcessInstance processInstance, ProcessModel processModel, String userId, String currentRole, DataRecord data) throws ProcessManagerException {
        try {
            Action creation = processModel.getAction(action);
            TaskDoneEvent event = this.getTask(processInstance, userId, currentRole).buildTaskDoneEvent(creation.getName(), data);
            Workflow.getWorkflowEngine().process(event, true);
            return event.getProcessInstance().getInstanceId();
        }
        catch (WorkflowException e) {
            throw new ProcessManagerException("Fail to process action " + action, e);
        }
    }

    private Task getTask(ProcessInstance processInstance, String userId, String currentRole) throws ProcessManagerException {
        try {
            UserImpl user = new UserImpl(UserDetail.getById((String)userId));
            Task[] tasks = Workflow.getTaskManager().getTasks((User)user, currentRole, processInstance);
            if (tasks.length > 0) {
                return tasks[0];
            }
            throw new ProcessManagerException(this.getClass().getName(), "processManager.NO_TASK");
        }
        catch (WorkflowException e) {
            throw new ProcessManagerException(SilverpeasExceptionMessages.failureOnGetting((String)"first task of process", (Object)processInstance), e);
        }
    }

    private Form getActionForm(ProcessModel processModel, String actionName, String role) throws ProcessManagerException {
        try {
            Action action = processModel.getAction(actionName);
            return processModel.getPublicationForm(action.getName(), role, this.getLanguage());
        }
        catch (WorkflowException e) {
            throw new ProcessManagerException(SilverpeasExceptionMessages.failureOnGetting((String)"form of action", (Object)actionName), e);
        }
    }

    private List<String> populateFields(String processId, String componentId, String userId, Map<String, Object> metadata, GenericDataRecord data, XmlForm form) throws ProcessManagerException {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        boolean versioningUsed = StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentId, "versionControl"));
        PagesContext pagesContext = new PagesContext("creationForm", "0", this.getLanguage(), true, componentId, userId);
        pagesContext.setObjectId(processId);
        pagesContext.setVersioningUsed(versioningUsed);
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String fieldName = entry.getKey();
            Object fieldValue = entry.getValue();
            String fieldType = this.retrieveMatchingFieldTypeName(fieldValue);
            Field field = this.findMatchingField(form, data, fieldName, fieldType);
            if (fieldValue == null) {
                this.populateSimpleField(field, fieldName, null, fieldType);
                continue;
            }
            if (fieldValue instanceof Collection) {
                this.populateListField(field, fieldName, (Collection)fieldValue, fieldType);
                continue;
            }
            if ("file".equals(fieldType)) {
                attachmentIds.add(this.populateFileField(form, data, (FileField)field, fieldName, (FileContent)fieldValue, pagesContext));
                continue;
            }
            this.populateSimpleField(field, fieldName, fieldValue, fieldType);
        }
        return attachmentIds;
    }
}

